% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVEMnet-package.R
\docType{package}
\name{SVEMnet-package}
\alias{SVEMnet-package}
\title{SVEMnet: Self-Validated Ensemble Models with Relaxed Lasso and Elastic-Net Regression}
\description{
The \code{SVEMnet} package implements Self-Validated Ensemble Models (SVEM)
using Elastic Net (including lasso and ridge) regression via \code{glmnet}.
SVEM averages predictions from multiple models fitted to fractionally
weighted bootstraps of the data, tuned with anti-correlated validation
weights. The package supports multi-response optimization with
uncertainty-aware candidate generation for iterative formulation and
process development.
}
\details{
A typical workflow is:
\enumerate{
\item Build a wide, deterministic factor expansion (optionally via
\code{\link{bigexp_terms}}) and reuse it across responses with
\code{\link{bigexp_formula}}.
\item Fit one or more SVEM models with \code{\link{SVEMnet}}.
\item Optionally run whole-model testing via
\code{\link{svem_significance_test_parallel}} (and
\code{\link{svem_wmt_multi}}) to assess factor
relationships or reweight response goals.
\item Call \code{\link{svem_score_random}} to draw random points in the
factor space, compute multi-response Derringer–Suich scores,
optional WMT-reweighted scores, and an uncertainty measure; then use
\code{\link{svem_select_from_score_table}} to pick a single "best"
row and diverse medoid candidates, and
\code{\link{svem_export_candidates_csv}} to export candidate tables
for the next experimental round.
\item Run new experiments at the suggested candidates, append the data,
refit the models, and repeat as needed (closed-loop optimization).
}
}
\section{Core modeling and summaries}{

\describe{
\item{\code{\link{SVEMnet}}}{Fit an SVEMnet model using Elastic Net regression
(including relaxed elastic net) on fractionally weighted bootstraps.}
\item{\code{\link{predict.svem_model}}}{Predict method for SVEM models
(ensemble-mean aggregation by default, optional debiasing, and
percentile prediction intervals when available).}
\item{\code{\link{coef.svem_model}}}{Averaged (optionally debiased)
coefficients from an SVEM model.}
\item{\code{\link{svem_nonzero}}}{Bootstrap nonzero percentages for each
coefficient, with an optional quick plot.}
\item{\code{\link{plot.svem_model}}}{Quick actual-versus-predicted plot for a
fitted model (with optional group colorings).}
}
}

\section{Deterministic wide expansions (bigexp helpers)}{

The \code{bigexp_*} helpers build and reuse a locked polynomial/interaction
expansion across multiple responses and datasets:
\describe{
\item{\code{\link{bigexp_terms}}}{Build a deterministic expanded RHS
(polynomials, interactions, optional partial-cubic terms) with
locked factor levels and numeric ranges.}
\item{\code{\link{bigexp_prepare}}}{Coerce new data to match a stored
\code{bigexp_spec}, including factor levels and numeric types.}
\item{\code{\link{bigexp_formula}}}{Reuse a locked expansion for another
response to ensure an identical factor space across models.}
\item{\code{\link{with_bigexp_contrasts}}}{Temporarily restore the
contrast options used when a \code{bigexp_spec} was built.}
\item{\code{\link{bigexp_train}}}{Convenience wrapper that builds a
\code{bigexp_spec} and prepares training data in one call.}
}
}

\section{Random tables, optimization, and candidate generation}{

\describe{
\item{\code{\link{svem_random_table_multi}}}{Generate one shared random
predictor table (with optional mixture constraints) from cached
factor-space information and obtain predictions from multiple SVEM
models at those points. Supports both Gaussian and binomial models;
binomial predictions are returned on the probability scale. This is
the lower-level sampler used by \code{\link{svem_score_random}}.}
\item{\code{\link{svem_score_random}}}{Random-search scoring for multiple
responses with Derringer–Suich desirabilities, user weights,
optional whole-model-test (WMT) reweighting, percentile CI-based
uncertainty, and (optionally) scoring of existing experimental data.
Returns a scored random-search table and, when \code{data} is
supplied, an augmented copy of the original data with
\code{<resp>_pred}, desirabilities, scores, and an
\code{uncertainty_measure}.}
\item{\code{\link{svem_select_from_score_table}}}{Given a scored table
(typically \code{svem_score_random()$score_table}), select one
"best" row under a chosen objective and a small, diverse set of
medoid candidates via PAM clustering on predictors.}
\item{\code{\link{svem_export_candidates_csv}}}{Concatenate one or more
selection objects from \code{\link{svem_select_from_score_table}}
and export candidate tables (with metadata, predictions, and
optional design-only trimming) to CSV or return them in-memory for
inspection.}
}
}

\section{Whole-model testing and plotting}{

\describe{
\item{\code{\link{svem_significance_test_parallel}}}{Parallel whole-model
significance test (using \code{foreach} + \code{doParallel}) with
support for mixture-constrained sampling and reuse of a locked
\code{bigexp_spec}. Designed for continuous (Gaussian) responses.}
\item{\code{\link{svem_wmt_multi}}}{Helper to run
\code{svem_significance_test_parallel} across multiple responses and
construct whole-model p-values and reweighting multipliers for use
in \code{\link{svem_score_random}}.}
\item{\code{\link[=plot.svem_significance_test]{plot.svem_significance_test}}}{Plot helper
for visualizing multiple significance-test outputs (observed vs
permutation distances, fitted null, and p-values).}
}
}

\section{Auxiliary utilities and data}{

\describe{
\item{\code{\link{glmnet_with_cv}}}{Convenience wrapper around repeated
\code{cv.glmnet()} selection for robust lambda (and optional alpha)
choice.}
\item{\code{\link{lipid_screen}}}{Example dataset for multi-response
modeling, whole-model testing, and mixture-constrained optimization
demonstrations.}
}
}

\section{Families}{

SVEMnet currently supports:
\itemize{
\item Gaussian responses (\code{family = "gaussian"}) with identity link
and optional debiasing / percentile prediction intervals.
\item Binomial responses (\code{family = "binomial"}) with logit link.
The response must be 0/1 numeric or a two-level factor (first level
treated as 0). Use \code{predict(..., type = "response")} for event
probabilities or \code{type = "class"} for 0/1 labels
(threshold = 0.5 by default).
}
Some higher-level utilities place additional constraints:
\itemize{
\item \code{\link{svem_significance_test_parallel}} is designed and
interpreted for continuous (Gaussian) responses.
\item \code{\link{svem_score_random}} supports mixed Gaussian + binomial
response sets, treating binomial predictions and CIs on the
probability scale, but WMT-based goal reweighting (via
\code{\link{svem_wmt_multi}} and the \code{wmt} argument) is only
allowed when all responses are Gaussian.
}
}

\section{Acknowledgments}{

OpenAI's GPT models (o1-preview through GPT-5 Pro) were
used to assist with coding and roxygen documentation; all
content was reviewed and finalized by the author.
}

\references{
Gotwalt, C., & Ramsey, P. (2018). Model Validation Strategies for Designed Experiments Using Bootstrapping Techniques With Applications to Biopharmaceuticals. \emph{JMP Discovery Conference}. \url{https://community.jmp.com/t5/Abstracts/Model-Validation-Strategies-for-Designed-Experiments-Using/ev-p/849873/redirect_from_archived_page/true}

Karl, A. T. (2024). A randomized permutation whole-model test heuristic for Self-Validated Ensemble Models (SVEM). \emph{Chemometrics and Intelligent Laboratory Systems}, \emph{249}, 105122. \doi{10.1016/j.chemolab.2024.105122}

Karl, A., Wisnowski, J., & Rushing, H. (2022). JMP Pro 17 Remedies for Practical Struggles with Mixture Experiments. JMP Discovery Conference. \doi{10.13140/RG.2.2.34598.40003/1}

Lemkus, T., Gotwalt, C., Ramsey, P., & Weese, M. L. (2021). Self-Validated Ensemble Models for Design of Experiments. \emph{Chemometrics and Intelligent Laboratory Systems}, 219, 104439. \doi{10.1016/j.chemolab.2021.104439}

Xu, L., Gotwalt, C., Hong, Y., King, C. B., & Meeker, W. Q. (2020). Applications of the Fractional-Random-Weight Bootstrap. \emph{The American Statistician}, 74(4), 345–358. \doi{10.1080/00031305.2020.1731599}

Ramsey, P., Gaudard, M., & Levin, W. (2021). Accelerating Innovation with Space Filling Mixture Designs, Neural Networks and SVEM. \emph{JMP Discovery Conference}. \url{https://community.jmp.com/t5/Abstracts/Accelerating-Innovation-with-Space-Filling-Mixture-Designs/ev-p/756841}

Ramsey, P., & Gotwalt, C. (2018). Model Validation Strategies for Designed Experiments Using Bootstrapping Techniques With Applications to Biopharmaceuticals. \emph{JMP Discovery Conference - Europe}. \url{https://community.jmp.com/t5/Abstracts/Model-Validation-Strategies-for-Designed-Experiments-Using/ev-p/849647/redirect_from_archived_page/true}

Ramsey, P., Levin, W., Lemkus, T., & Gotwalt, C. (2021). SVEM: A Paradigm Shift in Design and Analysis of Experiments. \emph{JMP Discovery Conference - Europe}. \url{https://community.jmp.com/t5/Abstracts/SVEM-A-Paradigm-Shift-in-Design-and-Analysis-of-Experiments-2021/ev-p/756634}

Ramsey, P., & McNeill, P. (2023). CMC, SVEM, Neural Networks, DOE, and Complexity: It's All About Prediction. \emph{JMP Discovery Conference}.

Friedman, J. H., Hastie, T., and Tibshirani, R. (2010).
Regularization Paths for Generalized Linear Models via Coordinate Descent.
Journal of Statistical Software, 33(1), 1-22.

Meinshausen, N. (2007).
Relaxed Lasso. Computational Statistics & Data Analysis, 52(1), 374-393.

Kish, L. (1965). \emph{Survey Sampling}. Wiley.

Lumley, T. (2004). Analysis of complex survey samples.
\emph{Journal of Statistical Software}, 9(1), 1–19.

Lumley, T. and Scott, A. (2015). AIC and BIC for modelling with complex survey data.
\emph{Journal of Survey Statistics and Methodology}, 3(1), 1–18.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://arxiv.org/abs/2511.20968}
}

}
\author{
\strong{Maintainer}: Andrew T. Karl \email{akarl@asu.edu} (\href{https://orcid.org/0000-0002-5933-8706}{ORCID})

}
\keyword{package}
