% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_slr.R
\name{p_slr}
\alias{p_slr}
\alias{gen_slr}
\title{p-value from simple linear regression model simulation}
\usage{
p_slr(
  n,
  beta,
  sd_x,
  sd_y,
  beta0 = 0,
  test = "x = 0",
  gen_fun = gen_slr,
  return_analysis = FALSE,
  ...
)

gen_slr(n, beta, sd_x, sd_y, ...)
}
\arguments{
\item{n}{sample size}

\item{beta}{slope parameter}

\item{sd_x}{standard deviation of IV}

\item{sd_y}{standard deviation of DV}

\item{beta0}{null value to test against}

\item{test}{test to evaluate using \code{\link[car]{lht}}.
Default evaluates the null hypothesis that the slope is equal to 0}

\item{gen_fun}{function used to generate the required X-Y data.
Object returned must be a \code{data.frame} with the columns
\code{'y'} and \code{'x'}. Default uses \code{\link{gen_slr}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
p-values associated with the simple linear regression model,
\eqn{y = \beta_0 + \beta_1 X + \epsilon}.
Focus is on the slope/intercept behavior of the model.
}
\examples{

p_slr(n=100, beta = -0.0667, sd_x = 7.5, sd_y = 4)

\dontrun{
p_slr(n=100, beta = -0.0667, sd_x = 7.5, sd_y = 4) |> Spower()
}

}
\seealso{
\code{\link{p_glm}}, \code{\link{p_lm.R2}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
