% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_helpers.R
\name{format_qca_solution}
\alias{format_qca_solution}
\title{Format a QCA solution expression}
\usage{
format_qca_solution(solution, var_names, use_tilde = TRUE)
}
\arguments{
\item{solution}{Character. A solution expression (e.g., "KSPRVT + ~KPRPRD").}

\item{var_names}{Character vector. Variable names used in the analysis.}

\item{use_tilde}{Logical. If TRUE, negation is represented as \code{~VAR}.}
}
\value{
Character. The formatted solution expression.
}
\description{
Formats a complete solution expression (multiple terms joined by +).
}
\examples{
var_names <- c("KSP", "KPR", "PRD", "RVT", "RCM")
format_qca_solution("KSPRVT + ~KPRPRD + RCM", var_names)
# Returns: "KSP*RVT + ~KPR*PRD + RCM"
}
