% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{menu}
\alias{menu}
\title{Interactive CLI Menu}
\usage{
menu(
  choices,
  prompt = "Select an item:",
  type = c("select", "checkbox"),
  selected = NULL,
  return_index = FALSE
)
}
\arguments{
\item{choices}{Character vector of choices to display}

\item{prompt}{Prompt message to display (default: "Select an item:")}

\item{type}{Menu type: "select" (single) or "checkbox" (multiple) (default: "select")}

\item{selected}{Pre-selected items (indices or values)}

\item{return_index}{Return indices instead of values (default: FALSE)}
}
\value{
Selected item(s) as character vector or indices, or NULL if cancelled
}
\description{
Creates an interactive menu in the R console allowing users to select items.
Inspired by inquirer.js, Python's pick, and Go's survey libraries.
}
\examples{
if (interactive()) {
  # Single selection
  color <- menu(c("Red", "Green", "Blue"), prompt = "Pick a color:")

  # Multiple selection
  toppings <- menu(
    c("Pepperoni", "Mushrooms", "Olives"),
    type = "checkbox",
    prompt = "Select toppings:"
  )
}
}
