% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{fm_detect_manifold}
\alias{fm_detect_manifold}
\alias{fm_crs_detect_manifold}
\alias{fm_detect_manifold.crs}
\alias{fm_detect_manifold.CRS}
\alias{fm_detect_manifold.numeric}
\alias{fm_detect_manifold.matrix}
\alias{fm_detect_manifold.fm_mesh_2d}
\title{Detect manifold type}
\usage{
fm_detect_manifold(x)

fm_crs_detect_manifold(x)

\method{fm_detect_manifold}{crs}(x)

\method{fm_detect_manifold}{CRS}(x)

\method{fm_detect_manifold}{numeric}(x)

\method{fm_detect_manifold}{matrix}(x)

\method{fm_detect_manifold}{fm_mesh_2d}(x)
}
\arguments{
\item{x}{Object to investigate}
}
\value{
A string containing the detected manifold classification
}
\description{
Detect if a 2d object is on "R2", "S2", or "M2"
}
\section{Functions}{
\itemize{
\item \code{fm_crs_detect_manifold()}: Detect if a crs is on "R2" or "S2"
(if \code{fm_crs_is_geocent(crs)} is \code{TRUE}). Returns \code{NA_character_} if the crs
is NULL or NA.

}}
\examples{
fm_detect_manifold(1:4)
fm_detect_manifold(rbind(c(1, 0, 0), c(0, 1, 0), c(1, 1, 0)))
fm_detect_manifold(rbind(c(1, 0, 0), c(0, 1, 0), c(0, 0, 1)))

}
