% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_pga_hbh}
\alias{load_pga_hbh}
\title{Load PGA Hole-by-Hole Data}
\usage{
load_pga_hbh(years, tournaments = NULL, top_n = 10, tour = "pga", dir = NULL)
}
\arguments{
\item{years}{Numeric vector. Year(s) to load.}

\item{tournaments}{Character vector. Optional tournament event IDs or names.
If NULL, loads all tournaments.}

\item{top_n}{Numeric. Number of top finishers to include scorecards for.
Default is 10. Set to NULL for all players.}

\item{tour}{Character. Tour type, default "pga".}

\item{dir}{Character. Optional directory to save CSV files.}
}
\value{
A tibble with hole-by-hole scoring data.
}
\description{
Loads detailed hole-by-hole scoring data for specified tournaments.
}
\examples{
\donttest{
# Load Masters hole-by-hole for top 10
masters_hbh <- load_pga_hbh(2025, tournaments = "401703504")

# Load with more players
masters_hbh <- load_pga_hbh(2025, tournaments = "401703504", top_n = 50)
}
}
