% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{weather_options}
\alias{weather_options}
\title{Set or get options for tidyweather}
\usage{
weather_options(...)
}
\arguments{
\item{...}{Option names to retrieve or key-value pairs to set.}
}
\value{
If called with no arguments, returns all current options.
If called with named arguments, updates and returns the modified options.
}
\description{
This function allows users to get or set configuration options for the
tidyweather package.
}
\details{
The options are managed via a nested structure that distinguishes between
the tidyweather package.
}
\section{Supported options}{

\describe{
\item{\code{extreme.frost_threshold}}{ Frost threshold for extreme weather events. }
\item{\code{require_full_year}}{ Whether to require a full year of data for calculations. }
}
}

\examples{
# Get all options
weather_options()

# Set frost_threshold
weather_options(extreme.frost_threshold = 2)

}
