\name{ind_test}
\alias{ind_test}
\title{Test for Complete Multivariate Independence}
\description{
Performs a test of total independence of the components of a multivariate random vector.
The test is an L2-type statistic based on characteristic functions, with optional score
transformations and resampling-based p-values.
}
\usage{
ind_test(X, n.rep = 200, score = "Identity", weight = "Gauss",
         strategy = "bootstrap", ncores = NULL, iseed = NULL)
}
\arguments{
  \item{X}{Matrix or data frame of numeric data; rows correspond to observations and columns to variables.}
  \item{n.rep}{Number of bootstrap replications or permutations used to approximate the null distribution.}
  \item{score}{Score transformation applied marginally to the data:
    \code{"Identity"} (raw data),
    \code{"Rank"} (componentwise ranks),
    or \code{"VdW"} (van der Waerden/normal scores).}
  \item{weight}{Weight function used in the L2-type statistic:
    \code{"Gauss"} (Gaussian) or \code{"Laplace"} (Laplace).}
  \item{strategy}{Resampling strategy used to obtain p-values:
    \code{"bootstrap"} or \code{"permutation"}.}
  \item{ncores}{Number of CPU cores to use for resampling computations. If \code{NULL}, computation is done sequentially.}
  \item{iseed}{Optional integer seed for reproducibility of resampling.}
}
\details{
The null hypothesis of the test is that all components of the random vector represented by \code{X}
are mutually independent. The test statistic is constructed as an L2-type distance between the
empirical joint characteristic function of the data and the product of the corresponding empirical
marginal characteristic functions.

\strong{Score transformations.}
The test may be applied directly to the data (\code{score = "Identity"}) or after marginal score
transformations. With \code{score = "Rank"}, each marginal variable is replaced by its scaled ranks,
leading to a test that is invariant under strictly increasing marginal transformations and
distribution-free under the null hypothesis. With \code{score = "VdW"}, van der Waerden (normal)
scores are used to enhance power under a broad class of alternatives.

\strong{Weight functions.}
The L2-type statistic involves integration with respect to a weight function on the characteristic
function domain. Gaussian and Laplace weights are available via \code{weight}.
van der Waerden scores are currently implemented only for Gaussian weights.

\strong{P-values via resampling.}
The null distribution of the test statistic is approximated using resampling:
\itemize{
  \item \code{strategy = "permutation"} independently permutes the observations within each variable,
  thereby destroying cross-component dependence while preserving marginal distributions.
  \item \code{strategy = "bootstrap"} generates a reference distribution using resampling with replacement
  under an independence structure.
}
The p-value is computed as the proportion of resampled statistics at least as large as the observed one.
}
\value{
An object of class \code{"htest"} containing:
\item{statistic}{The observed value of the test statistic.}
\item{p.value}{Approximate p-value based on resampling.}
\item{method}{A character string describing the test, including score, weight, and resampling strategy.}
\item{data.name}{Name of the input data \code{X}.}
\item{alternative}{A character string describing the alternative hypothesis (lack of mutual independence).}
\item{parameter}{The number of resampling replicates \code{n.rep}.}
}
\references{
Hallin, M., Meintanis, S.G. and Nordhausen, K. (2024),
\emph{Consistent distribution free affine invariant tests for the validity of independent component models}.
arXiv:2404.07632.
}
\seealso{
\code{\link{icm_test}}
}
\examples{
# in practice, the number of resamples should be much larger
n <- 100
X <- matrix(rnorm(n * 3), ncol = 3)

res <- ind_test(X)
res
}
\keyword{multivariate}



