% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{anki_cards_fsrs}
\alias{anki_cards_fsrs}
\title{Read cards with FSRS-6 parameters}
\usage{
anki_cards_fsrs(path = NULL, profile = NULL)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}
}
\value{
A tibble of cards with FSRS parameters:
\itemize{
\item \code{cid} - Card ID
\item \code{nid} - Note ID
\item \code{did} - Deck ID
\item \code{type} - Card type (0=new, 1=learning, 2=review, 3=relearning)
\item \code{queue} - Queue (-1=suspended, 0=new, 1=learning, 2=review, 3=day learning, 4=preview)
\item \code{due} - Due date/position
\item \code{ivl} - Current interval in days
\item \code{reps} - Number of reviews
\item \code{lapses} - Number of lapses
\item \code{stability} - FSRS stability (S) in days
\item \code{difficulty} - FSRS difficulty (D), range 1-10
\item \code{desired_retention} - Target retention rate
\item \code{decay} - FSRS-6 decay parameter (w20), typically 0.1-0.8
}
}
\description{
Extracts cards along with their FSRS (Free Spaced Repetition Scheduler)
memory state parameters. FSRS-6 stores stability, difficulty, and
a per-card decay parameter in the card's data field.
}
\examples{
\dontrun{
cards_fsrs <- anki_cards_fsrs()
# Calculate current retrievability
cards_fsrs$retrievability <- fsrs_retrievability(
  stability = cards_fsrs$stability,
  days_elapsed = as.numeric(Sys.Date() - as.Date("1970-01-01")) -
                 cards_fsrs$due / 86400,
  decay = cards_fsrs$decay
)
}
}
