% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{anki_search}
\alias{anki_search}
\title{Search cards like Anki's browser}
\usage{
anki_search(query, path = NULL, profile = NULL)
}
\arguments{
\item{query}{Search query string}

\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}
}
\value{
A tibble of matching cards
}
\description{
Searches cards using a simplified version of Anki's search syntax.
Supports: deck:name, tag:name, is:new, is:due, is:suspended, is:buried,
is:learn, is:review, prop:ivl>N, prop:lapses>N, prop:reps>N
}
\examples{
\dontrun{
# Find suspended cards
anki_search("is:suspended")

# Find cards in a specific deck
anki_search("deck:Default")

# Find cards with many lapses
anki_search("prop:lapses>5")

# Combine conditions
anki_search("deck:Medical is:review prop:ivl>30")
}
}
