% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_enhanced.R
\name{anki_search_enhanced}
\alias{anki_search_enhanced}
\title{Enhanced Search for Anki Cards}
\usage{
anki_search_enhanced(
  pattern,
  path = NULL,
  profile = NULL,
  case_sensitive = FALSE
)
}
\arguments{
\item{pattern}{Search pattern with support for advanced operators}

\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{case_sensitive}{Whether search is case-sensitive (default FALSE)}
}
\value{
A tibble with matching cards
}
\description{
Advanced search functionality supporting additional search operators beyond
the basic \code{anki_search()}.
}
\details{
Supported search operators:
\itemize{
\item \code{added:N} - Cards added in last N days
\item \code{rated:N} - Cards rated in last N days
\item \code{rated:N:ease} - Cards rated with specific ease (1-4) in last N days
\item \code{note:type} - Cards with specific note type name
\item \code{card:N} - Card template number (0-indexed)
\item \code{ivl:N} - Cards with interval >= N days
\item \verb{ivl:<N} - Cards with interval < N days
\item \code{prop:ease>N} - Cards with ease factor > N (e.g., prop:ease>2.5)
\item \code{prop:lapses>N} - Cards with lapses > N
\item \code{prop:reps>N} - Cards with reps > N
\item \code{re:pattern} - Regex search in card content
\item \code{OR} - OR operator between terms
\item Standard operators: \verb{deck:}, \verb{tag:}, \verb{is:}, \verb{flag:}
}
}
\examples{
\dontrun{
# Cards added in last 7 days
anki_search_enhanced("added:7")

# Cards rated "Again" in last 3 days
anki_search_enhanced("rated:3:1")

# Leeches with high lapses
anki_search_enhanced("is:leech prop:lapses>5")

# Regex search
anki_search_enhanced("re:^The\\\\s+")

# OR search
anki_search_enhanced("deck:German OR deck:Spanish")
}
}
