% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAntares.R
\name{readAntaresAreas}
\alias{readAntaresAreas}
\title{Read output for a list of areas}
\usage{
readAntaresAreas(
  areas,
  links = TRUE,
  clusters = TRUE,
  clustersRes = TRUE,
  internalOnly = FALSE,
  opts = simOptions(),
  ...
)
}
\arguments{
\item{areas}{Vector containing area names. It represents the set of areas we are interested
in. If \code{NULL}, all areas of the study are used.}

\item{links}{should links connected to the areas be imported ?}

\item{clusters}{should the thermal clusters of the areas be imported ?}

\item{clustersRes}{should the renewable clusters of the areas be imported ?}

\item{internalOnly}{If \code{TRUE}, only links that connect two areas from parameter \code{areas} are returned.
If not, the function also returns all the links that connect an area from the list with
an area outside the list.}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{...}{Other arguments passed to the function \code{\link{readAntares}}}
}
\value{
If \code{simplify = TRUE} and only one type of output is imported
then the result is a data.table.

Else an object of class "antaresData" is returned. It is a list of
data.tables, each element representing one type of element (areas, links,
clusters)
}
\description{
This a function is a wrapper for "antaresData" that reads all data for a
list of areas.
}
\examples{
\dontrun{
myarea <- simOptions()$areaList[1]
data <- readAntaresAreas(myarea)

# Equivalent but more concise than:
data2 <- readAntares(myarea, links = getLinks(myarea), clusters = myarea)

all.equal(data, data2)
}

}
