% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{agr}
\alias{agr}
\title{Absolute Growth Rate (AGR)}
\usage{
agr(ibw, fbw, duration)
}
\arguments{
\item{ibw}{numeric; value that is providing the initial body weight in
grams.}

\item{fbw}{numeric; value that is providing the final body weight in
grams.}

\item{duration}{numeric value that is providing the duration of the
experiment in days.}
}
\value{
returns a numeric value which is the total body weight change
over the specified period of time.
}
\description{
A function that calculates the Absolute Growth Rate (AGR), also denoted as
Weight Gain (WG) when applied to weight data.
}
\examples{
data(weight2)
dplyr::mutate(weight2, AGR = agr(ibw_g, fbw_g, duration = 84))

}
\references{
Lugert, V., Thaller, G., Tetens, J., Schulz, C., & Krieter, J.
(2016): A review on fish growth calculation: multiple functions in fish
production and their specific application. Reviews in Aquaculture, 8,
p.30–42.

Hopkins K.D. (1992) Reporting fish growth, a review of the 
basics. Journal of World Aquaculture Society, 23, p.173-179
}
\author{
Anıl Axel Tellbüscher

Madhav Karthikeyan

Davide A. Machado e Silva
}
