% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-azure-cli.R
\name{az_cli_get_cached_token}
\alias{az_cli_get_cached_token}
\title{Get Cached Token from MSAL Token Cache}
\usage{
az_cli_get_cached_token(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  config_dir = default_azure_config_dir()
)
}
\arguments{
\item{scope}{A character string specifying the OAuth2 scope to filter tokens.
If \code{NULL} (default), returns the latest-expiring token regardless of scope.}

\item{tenant_id}{A character string specifying the tenant ID to filter tokens.
If \code{NULL} (default), matches any tenant.}

\item{client_id}{A character string specifying the client ID to filter tokens.
If \code{NULL} (default), matches any client.}

\item{config_dir}{A character string specifying the Azure configuration
directory. Defaults to \code{\link[=default_azure_config_dir]{default_azure_config_dir()}}.}
}
\value{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing:
\itemize{
\item \code{access_token}: The OAuth2 access token string
\item \code{token_type}: The type of token (typically "Bearer")
\item \code{.expires_at}: POSIXct timestamp when the token expires
}
}
\description{
Reads the MSAL token cache file (\code{msal_token_cache.json}) from the Azure
configuration directory and returns a matching access token as an
\code{\link[httr2:oauth_token]{httr2::oauth_token()}} object.
}
\details{
The MSAL token cache is a JSON file maintained by the Azure CLI that stores
access tokens and refresh tokens. This function reads cached access tokens
directly from the file without invoking the Azure CLI, which can be useful
in environments where the CLI is slow or unavailable but tokens have been
previously cached.

When multiple tokens are found, the function selects the token that expires
latest. If \code{scope} is provided, only tokens matching that scope/resource are
returned.
}
\examples{
\dontrun{
# Get any cached token
token <- az_cli_get_cached_token()

# Get a cached token for a specific scope
token <- az_cli_get_cached_token(
  scope = "https://management.azure.com/.default"
)

# Access the token string
token$access_token
}

}
