% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_python_environment.R
\name{setup_python_environment}
\alias{setup_python_environment}
\title{Set Up Python Environment for BERTopic}
\usage{
setup_python_environment(
  envname = "r-bertopic",
  python_path = NULL,
  method = c("virtualenv", "conda"),
  python_version = NULL,
  upgrade = TRUE,
  extra_packages = NULL
)
}
\arguments{
\item{envname}{The name of the Python environment. Default is "r-bertopic".}

\item{python_path}{Optional path to a specific Python executable (virtualenv only).}

\item{method}{Environment type to create and use. One of "virtualenv" or "conda".}

\item{python_version}{Optional Python version for conda (e.g. "3.10").}

\item{upgrade}{Logical. If TRUE, passes --upgrade to pip installs. Default is TRUE.}

\item{extra_packages}{Optional character vector of additional Python packages to install.}
}
\value{
Invisibly returns the active Python configuration.
}
\description{
This function sets up a Python environment with all required packages for using
the BERTopic model within the R package. It can create and activate a virtualenv
or conda environment and then install the bundled requirements.
}
