% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_export.R
\name{bf_export}
\alias{bf_export}
\title{Export bitfield registries}
\usage{
bf_export(registry, format, file = NULL)
}
\arguments{
\item{registry}{\code{\link[=registry]{registry(1)}}\cr Registry object to export.}

\item{format}{\code{\link[=character]{character(1)}}\cr Export format. One of "json",
"xml", "yaml", or "rds".}

\item{file}{\code{\link[=character]{character(1)}}\cr Optional file path to write the
output. If NULL, returns the formatted data.}
}
\value{
Exported data as character string for formatted outputs, or the
registry object for "rds" format. If \code{file} is specified, returns
invisibly and writes to file.
}
\description{
Export bitfield registries in DataCite-compliant formats for archiving,
sharing, and integration with metadata repositories.
}
\examples{
\dontrun{
# Create registry with metadata
auth <- person("Jane", "Smith", email = "jane@example.com",
               comment = c(ORCID = "0000-0000-0000-0000"))
reg <- bf_registry(name = "analysis",
                   description = "Data quality assessment",
                   template = bf_tbl,
                   author = auth)

# Export to different formats
bf_export(registry = reg, format = "json", file = "metadata.json")
bf_export(registry = reg, format = "xml", file = "metadata.xml")
yaml_output <- bf_export(registry = reg, format = "yaml")
}
}
