% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.makeEncoding}
\alias{.makeEncoding}
\title{Determine encoding}
\usage{
.makeEncoding(var, type, ...)
}
\arguments{
\item{var}{the variable for which to determine encoding.}

\item{type}{the encoding type for which to determine encoding.}

\item{...}{\code{\link[=list]{list(.)}}\cr named list of options to determine encoding,
see Details.}
}
\value{
list of the encoding values for sign, exponent and significand, and
an additional provenance term.
}
\description{
Determine encoding
}
\details{
Floating-point values are encoded using three fields that map
directly to bit sequences. Any numeric value can be written in scientific
notation. For example, the decimal 923.52 becomes 9.2352 × 10^2. The same
principle applies in binary: the value 101011.101 becomes 1.01011101 × 2^5.
This binary scientific notation directly yields the three encoding fields:
\itemize{
\item Sign: whether the value is positive or negative (here: positive -> 0)
\item Exponent: the power of 2 (here: 5)
\item Significand: the fractional part after the leading 1 (here: 01011101)
}
For background on floating-point representation, see \href{https://www.cs.cornell.edu/~tomf/notes/cps104/floating}{'Floating
Point'} by Thomas Finley, or explore encodings interactively at
\href{https://float.exposed/}{https://float.exposed/}.

The allocation of bits across these fields can be adjusted to suit
different needs: more exponent bits provide a wider range (smaller minimums
and larger maximums), while more significand bits provide finer precision.
This package documents bit allocation using the notation [s.e.m], where
s = sign bits (0 or 1), e = exponent bits, and m = significand bits.

For non-numeric data (boolean or categorical), the same notation applies
with sign and exponent set to 0. A binary flag uses [0.0.1], while a
categorical variable with 8 levels requires 3 bits, yielding [0.0.3].

Possible options (\code{...}) of this function are \itemize{
\item \code{format}: switch that determines the configuration of the
\href{https://en.wikipedia.org/wiki/Bfloat16_floating-point_format}{floating point encoding}.
Possible values are \code{"half"} [1.5.10], \code{"bfloat16"}
[1.8.7], \code{"tensor19"} [1.8.10], \code{"fp24"} [1.7.16],
\code{"pxr24"} [1.8.15], \code{"single"} [1.8.23] and
\code{"double"} [1.11.52],
\item \code{fields}: list of custom values that control how many bits are
allocated to \code{sign}, \code{exponent} and \code{significand} for
encoding the numeric values,
\item \code{range}: the ratio between the smallest and largest possible
value to be reliably represented (modifies the exponent),
\item \code{decimals}: the number of decimal digits that should be
represented reliably (modifies the significand).
}
In a future version, it should also be possible to modify the bias to focus
number coverage to where it's most useful for the data.
}
