% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakebase.R
\name{db_lakebase_list}
\alias{db_lakebase_list}
\title{List Database Instances}
\usage{
db_lakebase_list(
  page_size = 50,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{page_size}{Maximum number of instances to return in a single page.}

\item{page_token}{Pagination token to retrieve the next page of results.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Database Instances
}
\examples{
\dontrun{
library(brickster)
library(DBI)
library(RPostgres)

# list all lakebase instances
dbs <- db_lakebase_list()

# connect to the first instance available using {RPostgres}
# using identity that brickster is running as generate a token
creds <- db_lakebase_creds_generate(instance_names = dbs[[1]]$name)

con <- dbConnect(
  drv = RPostgres::Postgres(),
  host = dbs[[1]]$read_write_dns,
  user = db_current_user()$userName,
  password = creds$token,
  dbname = "databricks_postgres",
  sslmode = "require"
)

dbListTables(con)
}

}
\seealso{
Other Database API: 
\code{\link{db_lakebase_creds_generate}()},
\code{\link{db_lakebase_get}()},
\code{\link{db_lakebase_get_by_uid}()}
}
\concept{Database API}
