% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_charging_station_details}
\alias{autobahn_charging_station_details}
\title{Get Autobahn charging station details}
\usage{
autobahn_charging_station_details(
  station_id,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{station_id}{Charging station identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with charging station details.
}
\description{
Get Autobahn charging station details
}
\details{
Returns full details for a single charging station entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
stations <- autobahn_charging_stations(roads$road_id[[1]])
autobahn_charging_station_details(stations$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_charging_stations]{autobahn_charging_stations()}} to list stations.
}
