% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_jobsuche.R
\name{jobsuche_search}
\alias{jobsuche_search}
\title{Search Jobsuche listings}
\usage{
jobsuche_search(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with job listings.

Includes parsed POSIXct columns (suffix \verb{_time}) in Europe/Berlin.
}
\description{
Search Jobsuche listings
}
\details{
The Jobsuche API provides access to job listings from the Bundesagentur fuer
Arbeit. Authentication is required via an API key passed as \code{X-API-Key}.
See https://jobsuche.api.bund.dev for the official API documentation.

Use \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure the key and \code{\link[=bunddev_parameters]{bunddev_parameters()}} to
discover supported query parameters.
}
\examples{
\dontrun{
Sys.setenv(JOBBOERSE_API_KEY = "jobboerse-jobsuche")
bunddev_auth_set("jobsuche", type = "api_key", env_var = "JOBBOERSE_API_KEY")
jobsuche_search(params = list(was = "data", size = 5), flatten = TRUE)
}

}
\seealso{
\code{\link[=jobsuche_search_app]{jobsuche_search_app()}} for the app endpoint, \code{\link[=jobsuche_logo]{jobsuche_logo()}} to fetch
employer logos, and \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} for authentication.
}
