% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_jobsuche.R
\name{jobsuche_search_app}
\alias{jobsuche_search_app}
\title{Search Jobsuche listings (app endpoint)}
\usage{
jobsuche_search_app(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with job listings.

Includes parsed POSIXct columns (suffix \verb{_time}) in Europe/Berlin.
}
\description{
Search Jobsuche listings (app endpoint)
}
\details{
This uses the mobile app endpoint of the Jobsuche API. It shares the same
authentication mechanism and parameters as \code{\link[=jobsuche_search]{jobsuche_search()}}.

See https://jobsuche.api.bund.dev for API documentation.
}
\examples{
\dontrun{
Sys.setenv(JOBBOERSE_API_KEY = "jobboerse-jobsuche")
bunddev_auth_set("jobsuche", type = "api_key", env_var = "JOBBOERSE_API_KEY")
jobsuche_search_app(params = list(was = "data", size = 5), flatten = TRUE)
}

}
\seealso{
\code{\link[=jobsuche_search]{jobsuche_search()}} for the standard endpoint and \code{\link[=bunddev_parameters]{bunddev_parameters()}} for
parameter discovery.
}
