context("guessType")

test_that("guessType", {
  xb = logical(10)
  xi = integer(10)
  xd = double(10)
  xc = complex(10)
  xs = letters[1:10]
  xl = as.list(1:10)
  xm = matrix(1:9, 3)
  xa = array(1:3)
  xf = data.frame(a=1:5, b=1:5)
  xx = 1; class(xx) = "Foo"
  xxx = 1; class(xxx) = c("Foo", "Bar")

  expect_equal(guessType(xb), "logical")
  expect_equal(guessType(xi), "integer")
  expect_equal(guessType(xd), "double")
  expect_equal(guessType(xc), "complex")
  expect_equal(guessType(xs), "character")
  expect_equal(guessType(xl), "list")
  expect_equal(guessType(xm), "matrix")
  expect_equal(guessType(xa), "array")
  expect_equal(guessType(xf), "data.frame")
  expect_equal(guessType(xx), "Foo")
  expect_equal(guessType(xxx), "Foo/Bar")

  expect_true(grepl("NULL'$", checkLogical(NULL)))
  expect_true(grepl("logical'$", checkInteger(xb)))
  expect_true(grepl("integer'$", checkLogical(xi)))
  expect_true(grepl("double'$", checkLogical(xd)))
  expect_true(grepl("complex'$", checkLogical(xc)))
  expect_true(grepl("character'$", checkLogical(xs)))
  expect_true(grepl("factor'$", checkLogical(factor(xs))))
  expect_true(grepl("list'$", checkLogical(xl)))
  expect_true(grepl("matrix'$", checkLogical(xm)))
  expect_true(grepl("array'$", checkLogical(xa)))
  expect_true(grepl("frame'$", checkLogical(xf)))
  expect_true(grepl("Foo'$", checkLogical(xx)))
  expect_true(grepl("Foo/Bar'$", checkLogical(xxx)))
})
