% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{get_fisher}
\alias{get_fisher}
\title{Get Fisher information function from problem}
\usage{
get_fisher(problem)
}
\arguments{
\item{problem}{An mle_problem object}
}
\value{
Fisher information function that takes a parameter vector and
  returns the Fisher information matrix (negative Hessian of log-likelihood).
}
\description{
Returns the Fisher information matrix function, computing numerically if not
provided. If \code{cache_derivatives = TRUE} was set in the problem and
Fisher is computed numerically, results are cached using a single-value
cache.
}
\examples{
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(1, 2))^2)
)
fisher_fn <- get_fisher(problem)
fisher_fn(c(1, 2))  # Fisher information at the optimum
}
