% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_preprocessing.R
\name{check_variable_health}
\alias{check_variable_health}
\title{Check variable health for matching}
\usage{
check_variable_health(
  left,
  right,
  vars,
  high_missingness_threshold = 0.5,
  low_variance_threshold = 1e-06
)
}
\arguments{
\item{left}{Data frame of left units}

\item{right}{Data frame of right units}

\item{vars}{Character vector of variable names to check}

\item{high_missingness_threshold}{Threshold for high missingness warning (default: 0.5)}

\item{low_variance_threshold}{Threshold for nearly-constant variables (default: 1e-6)}
}
\value{
A list with class "variable_health" containing:
\itemize{
\item \code{summary}: Tibble with per-variable diagnostics
\item \code{issues}: List of detected issues with severity levels
\item \code{exclude_vars}: Variables that should be excluded
\item \code{warnings}: Human-readable warnings
}
}
\description{
Analyzes variables for common problems that can affect matching quality:
constant columns, high missingness, extreme skewness, and outliers.
}
\keyword{internal}
