# tests/testthat/test-detect.R

test_that("detect_typo_type identifies keyboard errors", {
  result <- detect_typo_type("tesy", "test")
  expect_true("keyboard" %in% result$possible_types)
})

test_that("detect_typo_type identifies double letter", {
  result <- detect_typo_type("tesst", "test")
  expect_true("double" %in% result$possible_types)
})

test_that("detect_typo_type identifies omission", {
  result <- detect_typo_type("tst", "test")
  expect_true("omission" %in% result$possible_types)
})

test_that("suggest_corrections provides candidates", {
  result <- suggest_corrections("tesy")
  expect_type(result, "character")
  expect_true(length(result) > 0)
})

test_that("analyze_gaffe provides analysis", {
  result <- analyze_gaffe("covfefe", "coverage")
  expect_type(result, "list")
  expect_true("distance" %in% names(result))
  expect_true("typo_types" %in% names(result))
})
