% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_correlation.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Plot correlation}
\usage{
plot_correlation(
  df,
  vars = NULL,
  method = c("pearson", "spearman", "kendall"),
  use = "pairwise.complete.obs",
  triangle = c("full", "upper", "lower"),
  reorder = c("none", "hclust", "alphabetical"),
  digits = 2,
  label_size = 3,
  tile_color = "white",
  show_diag = TRUE,
  title = NULL
)
}
\arguments{
\item{df}{data.frame with numeric columns}

\item{vars}{optional vector of column names to include}

\item{method}{correlation method: "pearson", "spearman", or "kendall"}

\item{use}{handling of missing values for \code{stats::cor}}

\item{triangle}{which triangle to show: "full", "upper", or "lower"}

\item{reorder}{reordering strategy: "none", "hclust", or "alphabetical"}

\item{digits}{number of digits for labels}

\item{label_size}{size of label text}

\item{tile_color}{border color for tiles}

\item{show_diag}{whether to show the diagonal}

\item{title}{optional plot title}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Correlation heatmap with optional labels and triangle filtering.
}
\details{
Computes a correlation matrix from numeric columns (or \code{vars}) and renders a ggplot2
heatmap with values annotated. Supports reordering by hierarchical clustering or alphabetically.
}
\examples{
data(iris)
grf <- plot_correlation(iris[,1:4])
plot(grf)
}
