% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{edge_benchmark}
\alias{edge_benchmark}
\title{Performance benchmarking for model inference}
\usage{
edge_benchmark(
  ctx,
  prompt = "The quick brown fox",
  n_predict = 50,
  iterations = 3
)
}
\arguments{
\item{ctx}{Model context from edge_load_model()}

\item{prompt}{Test prompt to use for benchmarking (default: standard test)}

\item{n_predict}{Number of tokens to generate for the test}

\item{iterations}{Number of test iterations to average results}
}
\value{
List with performance metrics
}
\description{
Test inference speed and throughput with the current model to measure
the effectiveness of optimizations.
}
\examples{
\dontrun{
setup <- edge_quick_setup("TinyLlama-1.1B")
if (!is.null(setup$context)) {
  ctx <- setup$context
  perf <- edge_benchmark(ctx)
  print(perf)
  edge_free_model(ctx)
}
}
}
