% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_hypergeom_cocktail}
\alias{compute_hypergeom_cocktail}
\title{Function used to compute the Hypergeometric score on a cocktail}
\usage{
compute_hypergeom_cocktail(
  cocktail,
  upperBounds,
  ADRCount,
  observationsADR,
  observationsMedication,
  num_thread = 1L
)
}
\arguments{
\item{cocktail}{: A cocktail in the form of vector of integers (ATC index)}

\item{upperBounds}{: ATC tree  upper bound of the DFS (without the root)}

\item{ADRCount}{: number of patient experiencing ADR in dataset}

\item{observationsADR}{: observation of the ADR for each patients
(a vector containing the ADR on which we want to compute the risk distribution)}

\item{observationsMedication}{: observation of the drug intake for each patients
on which we want to compute the risk distribution}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}
}
\value{
Hypergeometric score of the "cocktail" parameter
}
\description{
Function used to compute the Hypergeometric score on a cocktail
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

ADRCount = sum(FAERS_myopathy$patientADR)
cocktail = c(561, 904)

Hypergeom_of_cocktail = compute_hypergeom_cocktail(cocktail = cocktail,
                              upperBounds = ATC_Tree_UpperBound_2024$upperBound,
                              ADRCount =  ADRCount,
                              observationsADR = FAERS_myopathy$patientADR,
                              observationsMedication = FAERS_myopathy$patientATC,
                              num_thread=8)
}
}
