% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.blockdiag.R
\name{blockdiag-ergmConstraint}
\alias{blockdiag-ergmConstraint}
\alias{InitErgmConstraint.blockdiag}
\title{Block-diagonal structure constraint}
\usage{
# blockdiag(attr, noncontig = "merge")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{noncontig}{character: what to do if the blocks are not contiguous? \describe{

\item{\code{"merge"}}{A placeholder option, to treat them as the same block. It may be implemented in the future, and an explicit \code{"stop"} option added later.}

\item{\code{"split"}}{Treat them as separate blocks.}

}}
}
\description{
Force a block-diagonal structure (and its bipartite analogue) on
the network. Only dyads \eqn{(i,j)} for which
\code{attr(i)==attr(j)} can have edges.
}
\details{
For bipartite graphs, blocks must be have the same
ordering in both partitions. (They do not, however, require that
all blocks be represented in both partitions, but those that
overlap must have the same order.)

If multiple block-diagonal constraints are given, or if
\code{attr} is a vector with multiple attribute names, blocks
will be constructed on all attributes matching.
}
\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "blockdiag", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
