% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sampson}
\alias{sampson}
\alias{samplike}
\alias{samplk}
\alias{samplk1}
\alias{samplk2}
\alias{samplk3}
\alias{sampdlk1}
\alias{sampdlk2}
\alias{sampdlk3}
\title{Longitudinal and cumulative networks of positive and negative affect in a monastery}
\source{
\insertCite{Sa68n}{ergm}.

\url{https://github.com/bavla/Nets/raw/refs/heads/master/data/Pajek/esna/Sampson.zip}
}
\usage{
data(sampson)
data(samplk)
}
\description{
A collection of \code{\link[network:network]{network}} objects containing the "liking"
nominations of the monks studied by \insertCite{Sa68n;textual}{ergm} over the three time points:
\code{data(samplk)} contains the time-sliced networks of liking and
disliking (\code{samplk1}, \code{samplk2}, \code{samplk3}, \code{sampdlk1}, \code{sampdlk2},
and \code{sampdlk3}) and \code{data(sampson)} (\code{samplike}) a network cumulative network
of liking nominations.
}
\details{
\insertCite{Sa68n;textual}{ergm} recorded the social interactions among a group of monks while
he was a resident as an experimenter at the cloister.  During his stay, a
political "crisis in the cloister" resulted in the expulsion of four
monks-- namely, the three "outcasts," Brothers Elias, Simplicius, Basil, and
the leader of the "young Turks," Brother Gregory.  Not long after Brother
Gregory departed, all but one of the "young Turks" left voluntarily:
Brothers John Bosco, Albert, Boniface, Hugh, and Mark.  Then, all three of
the "waverers" also left: First, Brothers Amand and Victor, then later
Brother Romuald.  Eventually, Brother Peter and Brother Winfrid also left,
leaving only four of the original group.

Of particular interest are the data on positive affect relations
("liking," using the terminology later adopted by \insertCite{WhBo76s;textual}{ergm}), in which each monk was asked to list three monks with
whom he had positive affect ("liked the most", "liked 2nd most",
and "liked 3rd most") and three monks with whom he had negative
affect ("liked the least", "liked 2nd least", liked 3rd
least"). (Some did not comply fully and provided additional names, forcing ties.)

The data were gathered at three times to capture changes in group sentiment
over time. They represent three time points in the period during which a new
cohort had entered the monastery near the end of the study but before the
major conflict began.  These three time points are labeled T2, T3, and T4 in
Tables D5 through D16 in the appendices of Sampson's 1969 dissertation.

This data set is standard in the social network analysis
literature, having been modeled by \insertCite{HoLe81e;textual}{ergm},
\insertCite{Re82u;textual}{ergm}, \insertCite{HoLa83s;textual}{ergm},
\insertCite{FiWa81c;textual}{ergm}, \insertCite{HoRa02l;textual}{ergm}
(using \code{samplk3}), and \insertCite{KrHa09r;textual}{ergm}
(\code{samplike}).  This is only a small piece of the data collected by
Sampson.
\subsection{Common attributes}{

All of the networks contain the following identical vertex attributes:
\describe{

\item{\code{cloisterville}}{An indicator
of attendance at the minor seminary of "Cloisterville" before coming to
the monastery.}

\item{\code{vertex.names}}{The given names of the novices.  NB:
These names have been corrected as of \code{ergm} version 3.6.1; see details
below.}

\item{\code{group4}}{The original grouping by Sampson ("[Young] Turks",
"Loyal [Opposition]", "Outcasts", and "Waverers").}

\item{\code{group3}}{As \code{group4}, but with "Waverers" merged into their
nearest group; retained for historical reasons.}

}

Note that the \code{group} vertex attribute differs between \code{sampson}
and \code{samplk} for historical reasons.
}

\subsection{Time-sliced networks (\code{samplk})}{

The data from the three time points (T2, T3, T4) are provided as
\code{samplk1}, \code{samplk2}, and \code{samplk3} for liking most and
\code{sampdlk1}, \code{sampdlk2}, and \code{sampdlk3} for liking least,
respectively. A directed edge from monk A to monk B exists if A
nominated B among his top three (or four, in case of ties) choices
at that time point. Each network also has an edge attribute
\code{score}, indicating the ranking given:\tabular{lr}{
   list \tab score \cr
   liked the most \tab +3 \cr
   liked 2nd most \tab +2 \cr
   liked 3rd most \tab +1 \cr
   not nominated \tab 0 \cr
   liked 3rd least \tab -1 \cr
   liked 2nd least \tab -2 \cr
   liked the least \tab -3 \cr
}


Note that the \code{samplk[1-3]} networks only contain positive scores
and \code{sampdlk[1-3]} only negative.

For historical reasons, their vertex attribute \code{group} is the same
as \code{group4} described above.
}

\subsection{Cumulative ties (\code{sampson})}{

The \code{samplike} network is the time-aggregated network.  Thus,
a tie from monk A to monk B exists if A nominated B as one of his
three (or four, in case of ties) most liked at any of the three
time points. An edge attribute, \code{nominations}, gives the
number of times (out of 3) that monk A nominated monk B.

For historical reasons, its vertex attribute \code{group} is the same as
\code{group3} described above.
}
}
\section{History}{

\subsection{Dislike networks, edge scores, and \code{group} harmonization}{

\pkg{ergm} 4.11 added dislike networks \code{sampdlk[1-3]}; note that
unlike the positive affection networks, it is not clear whether
these were collected contemporaneously or retrospectively.

For all networks in \code{samplk}, scores reflecting the position in the
ranking were added.

The \code{group} vertex attribute meaning differed between the \code{sampson}
(\code{samplike}) and the \code{samplk} networks and will continue to do so
for reproducibility; for removal of ambiguity, both datasets now
have \code{group3} and \code{group4} vertex attributes, with \code{group3}
inherited from \code{sampson} and \code{group4} from \code{samplk}.
}

\subsection{Cloisterville and vertex names}{

This data set was updated for version 2.5 (March 2012) to add the
\code{cloisterville} variable and refine the names. This information is from
\insertCite{DeNo05e;textual}{ergm}. The original vertex names were:
Romul_10, Bonaven_5, Ambrose_9, Berth_6, Peter_4, Louis_11, Victor_8,
Winf_12, John_1, Greg_2, Hugh_14, Boni_15, Mark_7, Albert_16, Amand_13,
Basil_3, Elias_17, Simp_18. The numbers indicate the ordering used in the
original dissertation of \insertCite{Sa68n;textual}{ergm}.
}

\subsection{Mislabeling in Versions Prior to 3.6.1}{

In \pkg{ergm} version 3.6.0 and earlier, The adjacency matrices of
the \code{\link{samplike}}, \code{\link{samplk1}}, \code{\link{samplk2}}, and \code{\link{samplk3}}
networks reflected the original \insertCite{Sa68n;textual}{ergm} ordering of the
names even though the vertex labels used the name order of \insertCite{DeNo05e;textual}{ergm}.
That is, in \code{ergm} version 3.6.0
and earlier, the vertices were mislabeled. The correct order is the
same one given in Tables D5, D9, and D13 of \insertCite{Sa68n;textual}{ergm}: John
Bosco, Gregory, Basil, Peter, Bonaventure, Berthold, Mark, Victor,
Ambrose, Romauld (Sampson uses both spellings "Romauld" and
"Ramauld" in the dissertation), Louis, Winfrid, Amand, Hugh,
Boniface, Albert, Elias, Simplicius. By contrast, the order given
in \code{ergm} version 3.6.0 and earlier is: Ramuald, Bonaventure,
Ambrose, Berthold, Peter, Louis, Victor, Winfrid, John Bosco,
Gregory, Hugh, Boniface, Mark, Albert, Amand, Basil, Elias,
Simplicius.
}
}

\examples{

data(samplk)

# Table D5 in \insertCite{Sa68n;textual}{ergm}
as.matrix(samplk1, attrname = "score") + as.matrix(sampdlk1, attrname = "score")

# Table D9
as.matrix(samplk2, attrname = "score") + as.matrix(sampdlk2, attrname = "score")

# Table D13
as.matrix(samplk3, attrname = "score") + as.matrix(sampdlk3, attrname = "score")

# Cumulative ties in `samplike`
data(sampson)
all(as.matrix(samplike) ==
    as.matrix(samplk1) | as.matrix(samplk2) | as.matrix(samplk3))
all(as.matrix(samplike, attrname = "nominations") ==
    as.matrix(samplk1) + as.matrix(samplk2) + as.matrix(samplk3))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{florentine}}, \code{\link[network:network]{network}}, \code{\link[network:plot.network]{plot.network}}, \code{\link{ergm}}
}
\keyword{datasets}
