% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson2multinom.R
\name{poisson2multinom}
\alias{poisson2multinom}
\title{Recover Multinomial Topic Model Fit from Poisson NMF fit}
\usage{
poisson2multinom(fit)
}
\arguments{
\item{fit}{An object of class \dQuote{poisson_nmf_fit}, such as an
output from \code{fit_poisson_nmf}. It does not make sense for a
multinomial topic model to have less than two topics, so an error
will be reported when k < 2, where k is the rank of the matrix
factorization. If a multinomial topic model fit is provided (that
is, an object of class \dQuote{multinom_topic_model_fit}), the fit
object is immediately returned \dQuote{as is}.}
}
\value{
The return value is the list \code{fit}, in which
  \code{fit$F} and \code{fit$L} are the parameters of the multinomial
  topic model; specifically, \code{fit$L[i,]} gives the topic
  probabilities for sample or document i, and \code{fit$F[,k]} gives
  the term probabilities for topic k. An additional vector
  \code{fit$s} of length n is returned giving the "size factors".
}
\description{
This function recovers parameter estimates of the
  multinomial topic model given parameter estimates for a Poisson
  non-negative matrix factorization (NMF).
}
