% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_set.R
\name{RuleSet}
\alias{RuleSet}
\title{R6 class for a Rule Set}
\description{
This class implements a generic rule set (LHS -> RHS), serving as the parent
class for \code{ImplicationSet}. It provides common functionality for
managing, filtering, and exporting rules.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RuleSet-new}{\code{RuleSet$new()}}
\item \href{#method-RuleSet-get_attributes}{\code{RuleSet$get_attributes()}}
\item \href{#method-RuleSet-bracket}{\code{RuleSet$[()}}
\item \href{#method-RuleSet-to_arules}{\code{RuleSet$to_arules()}}
\item \href{#method-RuleSet-add}{\code{RuleSet$add()}}
\item \href{#method-RuleSet-cardinality}{\code{RuleSet$cardinality()}}
\item \href{#method-RuleSet-is_empty}{\code{RuleSet$is_empty()}}
\item \href{#method-RuleSet-size}{\code{RuleSet$size()}}
\item \href{#method-RuleSet-print}{\code{RuleSet$print()}}
\item \href{#method-RuleSet-get_quality}{\code{RuleSet$get_quality()}}
\item \href{#method-RuleSet-to_latex}{\code{RuleSet$to_latex()}}
\item \href{#method-RuleSet-get_LHS_matrix}{\code{RuleSet$get_LHS_matrix()}}
\item \href{#method-RuleSet-get_RHS_matrix}{\code{RuleSet$get_RHS_matrix()}}
\item \href{#method-RuleSet-filter}{\code{RuleSet$filter()}}
\item \href{#method-RuleSet-get_implications}{\code{RuleSet$get_implications()}}
\item \href{#method-RuleSet-support}{\code{RuleSet$support()}}
\item \href{#method-RuleSet-confidence}{\code{RuleSet$confidence()}}
\item \href{#method-RuleSet-to_json}{\code{RuleSet$to_json()}}
\item \href{#method-RuleSet-clone}{\code{RuleSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-new}{}}}
\subsection{Method \code{new()}}{
Initialize a RuleSet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A \code{rules} object (from \code{arules}) or named arguments:
\code{name} (string), \code{attributes} (character vector),
\code{lhs} and \code{rhs} (sparse matrices), \code{I} (incidence matrix),
\code{quality} (data.frame), \code{confidence} (numeric vector, backward compat).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RuleSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Get the names of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with the names of the attributes used in the rules.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-bracket"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-bracket}{}}}
\subsection{Method \code{[()}}{
Get a subset of the rule set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$[(idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idx}}{(integer or logical vector) Indices of the rules to extract or remove. If logical vector, only \code{TRUE} elements are retained and the rest discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RuleSet} with only the rules given by the \code{idx} indices.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-to_arules"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-to_arules}{}}}
\subsection{Method \code{to_arules()}}{
Convert to arules format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$to_arules(quality = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quality}}{(logical) Compute/include the interest measures for each rule?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{rules} object as used by package \code{arules}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-add"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-add}{}}}
\subsection{Method \code{add()}}{
Add a precomputed rule set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A \code{RuleSet} object, or a pair \code{lhs}, \code{rhs} of \code{dgCMatrix}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, just updates the internal field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-cardinality"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-cardinality}{}}}
\subsection{Method \code{cardinality()}}{
Cardinality: Number of rules in the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$cardinality()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The cardinality of the rule set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Empty set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the set of rules is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-size"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-size}{}}}
\subsection{Method \code{size()}}{
Size: number of attributes in each of LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix with two columns: the number of attributes present in each of the LHS and RHS of each rule.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-print}{}}}
\subsection{Method \code{print()}}{
Print all rules to text
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with all the rules in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-get_quality"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-get_quality}{}}}
\subsection{Method \code{get_quality()}}{
Get quality metrics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$get_quality()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame with the quality metrics for each rule.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Export to LaTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$to_latex(
  print = TRUE,
  ncols = 1,
  numbered = TRUE,
  numbers = seq_len(self$cardinality())
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}

\item{\code{ncols}}{(integer) Number of columns for the output.}

\item{\code{numbered}}{(logical) If \code{TRUE} (default), implications will be numbered in the output.}

\item{\code{numbers}}{(vector) If \code{numbered}, use these elements to enumerate the implications. The default is to enumerate 1, 2, ..., but can be changed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string in LaTeX format that prints nicely all the rules.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-get_LHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-get_LHS_matrix}{}}}
\subsection{Method \code{get_LHS_matrix()}}{
Get internal LHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$get_LHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the LHS of the rules in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-get_RHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-get_RHS_matrix}{}}}
\subsection{Method \code{get_RHS_matrix()}}{
Get internal RHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$get_RHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the RHS of the rules in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-filter"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-filter}{}}}
\subsection{Method \code{filter()}}{
Filter rules by attributes in LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$filter(
  lhs = NULL,
  not_lhs = NULL,
  rhs = NULL,
  not_rhs = NULL,
  drop = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lhs}}{(character vector) Names of the attributes to filter the LHS by. If \code{NULL}, no filtering is done on the LHS.}

\item{\code{not_lhs}}{(character vector) Names of the attributes to not include in the LHS. If \code{NULL} (the default), it is not considered at all.}

\item{\code{rhs}}{(character vector) Names of the attributes to filter the RHS by. If \code{NULL}, no filtering is done on the RHS.}

\item{\code{not_rhs}}{(character vector) Names of the attributes to not include in the RHS. If \code{NULL} (the default), it is not considered at all.}

\item{\code{drop}}{(logical) Remove the rest of attributes in RHS?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{RuleSet} (or subclass) that is a subset of the current set, only with those rules which have the attributes in \code{lhs} and \code{rhs} in their LHS and RHS, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-get_implications"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-get_implications}{}}}
\subsection{Method \code{get_implications()}}{
Extract the implications with confidence 1
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$get_implications()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{ImplicationSet} object containing only the rules with confidence 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-support"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-support}{}}}
\subsection{Method \code{support()}}{
Compute support of each rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each rule.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-confidence"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-confidence}{}}}
\subsection{Method \code{confidence()}}{
Compute the confidence of each rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$confidence()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector with the confidence of each rule.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-to_json"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-to_json}{}}}
\subsection{Method \code{to_json()}}{
Export the rule set to JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$to_json(file = NULL, return_list = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) The path of the file to save the JSON to.}

\item{\code{return_list}}{(logical) If TRUE, returns the list representation instead of the JSON string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A JSON string representing the rule set, or a list if \code{return_list} is TRUE.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RuleSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RuleSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RuleSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
