% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/sampling_frame.R
\name{acquisition_onsets}
\alias{acquisition_onsets}
\alias{acquisition_onsets.sampling_frame}
\title{Get fMRI Acquisition Onset Times}
\usage{
acquisition_onsets(x, ...)

\method{acquisition_onsets}{sampling_frame}(x, ...)
}
\arguments{
\item{x}{A sampling_frame object}

\item{...}{Additional arguments (for extensibility)}
}
\value{
Numeric vector of acquisition onset times in seconds
}
\description{
Calculate the onset time in seconds for each fMRI volume acquisition
from the start of the experiment.
}
\details{
Returns the temporal onset of each brain volume acquisition, accounting
for TR, start_time, and run structure. This is essentially a convenience
wrapper around \code{samples(x, global = TRUE)} that provides clearer
semantic meaning for the common use case of getting acquisition times.

Note: The onset times include the start_time offset (default TR/2),
so the first acquisition typically doesn't start at 0.
}
\examples{
# Single block with default start_time (TR/2 = 1)
sf <- sampling_frame(blocklens = 100, TR = 2)
onsets <- acquisition_onsets(sf)
head(onsets)  # Returns: 1, 3, 5, 7, 9, 11, ...

# Multiple blocks with same TR
sf2 <- sampling_frame(blocklens = c(100, 120), TR = 2)
onsets2 <- acquisition_onsets(sf2)
# First block: 1, 3, 5, ..., 199
# Second block: 201, 203, 205, ..., 439

# Variable TR per block
sf3 <- sampling_frame(blocklens = c(100, 100), TR = c(2, 1.5))
onsets3 <- acquisition_onsets(sf3)
# First block: 1, 3, 5, ..., 199 (TR=2)
# Second block: 200.75, 202.25, 203.75, ... (TR=1.5, start_time=0.75)

# Custom start times
sf4 <- sampling_frame(blocklens = c(50, 50), TR = 2, start_time = 0)
onsets4 <- acquisition_onsets(sf4)
head(onsets4)  # Returns: 0, 2, 4, 6, 8, 10, ...
}
\seealso{
\code{\link{samples}} for more flexible timing queries
}
