% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gbm.R
\name{plot.gbm}
\alias{plot.gbm}
\title{Marginal plots of fitted gbm objects}
\usage{
\method{plot}{gbm}(
  x,
  i.var = 1,
  n.trees = x$n.trees,
  continuous.resolution = 100,
  return.grid = FALSE,
  type = c("link", "response"),
  level.plot = TRUE,
  contour = FALSE,
  number = 4,
  overlap = 0.1,
  col.regions = viridis::viridis,
  ...
)
}
\arguments{
\item{x}{A \code{\link{gbm.object}} that was fit using a call to 
\code{\link{gbm}}.}

\item{i.var}{Vector of indices or the names of the variables to plot. If
using indices, the variables are indexed in the same order that they appear
in the initial \code{gbm} formula. If \code{length(i.var)} is between 1 and
3 then \code{plot.gbm} produces the plots. Otherwise, \code{plot.gbm}
returns only the grid of evaluation points and their average predictions}

\item{n.trees}{Integer specifying the number of trees to use to generate the 
plot. Default is to use \code{x$n.trees} (i.e., the entire ensemble).}

\item{continuous.resolution}{Integer specifying the number of equally space 
points at which to evaluate continuous predictors.}

\item{return.grid}{Logical indicating whether or not to produce graphics 
\code{FALSE} or only return the grid of evaluation points and their average
predictions \code{TRUE}. This is useful for customizing the graphics for 
special variable types, or for higher dimensional graphs.}

\item{type}{Character string specifying the type of prediction to plot on the 
vertical axis. See \code{\link{predict.gbm}} for details.}

\item{level.plot}{Logical indicating whether or not to use a false color 
level plot (\code{TRUE}) or a 3-D surface (\code{FALSE}). Default is 
\code{TRUE}.}

\item{contour}{Logical indicating whether or not to add contour lines to the
level plot. Only used when \code{level.plot = TRUE}. Default is \code{FALSE}.}

\item{number}{Integer specifying the number of conditional intervals to use
for the continuous panel variables. See \code{\link[graphics:coplot]{co.intervals}}
and \code{\link[lattice:shingles]{equal.count}} for further details.}

\item{overlap}{The fraction of overlap of the conditioning variables. See
\code{\link[graphics:coplot]{co.intervals}} and \code{\link[lattice:shingles]{equal.count}}
for further details.}

\item{col.regions}{Color vector to be used if \code{level.plot} is
\code{TRUE}. Defaults to the wonderful Matplotlib 'viridis' color map
provided by the \code{viridis} package. See \code{\link[viridis:reexports]{viridis}}
for details.}

\item{...}{Additional optional arguments to be passed onto 
\code{\link[graphics:plot.default]{plot}}.}
}
\value{
If \code{return.grid = TRUE}, a grid of evaluation points and their 
average predictions. Otherwise, a plot is returned.
}
\description{
Plots the marginal effect of the selected variables by "integrating" out the
other variables.
}
\details{
\code{plot.gbm} produces low dimensional projections of the
\code{\link{gbm.object}} by integrating out the variables not included in
the \code{i.var} argument. The function selects a grid of points and uses
the weighted tree traversal method described in Friedman (2001) to do the
integration. Based on the variable types included in the projection,
\code{plot.gbm} selects an appropriate display choosing amongst line plots,
contour plots, and \code{\link[lattice:Lattice]{lattice}} plots. If the default
graphics are not sufficient the user may set \code{return.grid = TRUE}, store
the result of the function, and develop another graphic display more
appropriate to the particular example.
}
\note{
More flexible plotting is available using the 
\code{\link[pdp]{partial}} and \code{\link[pdp]{plotPartial}} functions.
}
\references{
J. H. Friedman (2001). "Greedy Function Approximation: A Gradient
Boosting Machine," Annals of Statistics 29(4).

B. M. Greenwell (2017). "pdp: An R Package for Constructing 
Partial Dependence Plots," The R Journal 9(1), 421--436. 
\url{https://journal.r-project.org/articles/RJ-2017-016/index.html}.
}
\seealso{
\code{\link[pdp]{partial}}, \code{\link[pdp]{plotPartial}}, 
\code{\link{gbm}}, and \code{\link{gbm.object}}.
}
