% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_class.R
\name{girafe_class}
\alias{girafe_class}
\alias{girafe_class_add}
\alias{girafe_class_remove}
\alias{girafe_class_toggle}
\title{Add, remove or toggle CSS classes on girafe elements}
\usage{
girafe_class_add(
  session,
  id,
  class,
  data_id = NULL,
  key_id = NULL,
  theme_id = NULL
)

girafe_class_remove(
  session,
  id,
  class,
  data_id = NULL,
  key_id = NULL,
  theme_id = NULL
)

girafe_class_toggle(
  session,
  id,
  class,
  data_id = NULL,
  key_id = NULL,
  theme_id = NULL
)
}
\arguments{
\item{session}{The Shiny session object.}

\item{id}{The output id of the girafe element
(the \code{outputId} used in \code{\link[=girafeOutput]{girafeOutput()}}).}

\item{class}{A non-empty character string of CSS class names to
add, remove, or toggle.}

\item{data_id}{A character vector of \code{data-id} values identifying
the target elements.}

\item{key_id}{A character vector of \code{key-id} values identifying
the target elements.}

\item{theme_id}{A character vector of \code{theme-id} values identifying
the target elements.}
}
\description{
These functions allow programmatic manipulation of CSS classes
on SVG elements within a girafe output in Shiny applications.
Elements are targeted by their \code{data-id}, \code{key-id}, or \code{theme-id}
attributes.
}
\details{
At least one of \code{data_id}, \code{key_id}, or \code{theme_id} must be provided.

These functions send a custom message to the JavaScript side,
which applies the CSS class operation to all matching SVG elements
within the girafe root node.
}
\examples{
\dontrun{
# In a Shiny server function:
girafe_class_add(session, "plot", "highlighted", data_id = "some_id")
girafe_class_remove(session, "plot", "highlighted", data_id = "some_id")
girafe_class_toggle(session, "plot", "highlighted", data_id = "some_id")
}
}
