% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\docType{data}
\name{GGML_GLU_OP_REGLU}
\alias{GGML_GLU_OP_REGLU}
\alias{GGML_GLU_OP_GEGLU}
\alias{GGML_GLU_OP_SWIGLU}
\alias{GGML_GLU_OP_SWIGLU_OAI}
\alias{GGML_GLU_OP_GEGLU_ERF}
\alias{GGML_GLU_OP_GEGLU_QUICK}
\title{GLU Operation Types}
\format{
Integer constants

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.

An object of class \code{integer} of length 1.
}
\usage{
GGML_GLU_OP_REGLU

GGML_GLU_OP_GEGLU

GGML_GLU_OP_SWIGLU

GGML_GLU_OP_SWIGLU_OAI

GGML_GLU_OP_GEGLU_ERF

GGML_GLU_OP_GEGLU_QUICK
}
\value{
An integer constant representing a GLU operation type
}
\description{
Constants for GLU (Gated Linear Unit) operation types.
Used with ggml_glu() and ggml_glu_split().
}
\details{
\itemize{
  \item \code{GGML_GLU_OP_REGLU} (0): ReGLU - ReLU gating
  \item \code{GGML_GLU_OP_GEGLU} (1): GeGLU - GELU gating (used in GPT-NeoX, Falcon)
  \item \code{GGML_GLU_OP_SWIGLU} (2): SwiGLU - SiLU/Swish gating (used in LLaMA, Mistral)
  \item \code{GGML_GLU_OP_SWIGLU_OAI} (3): SwiGLU OpenAI variant
  \item \code{GGML_GLU_OP_GEGLU_ERF} (4): GeGLU with exact erf implementation
  \item \code{GGML_GLU_OP_GEGLU_QUICK} (5): GeGLU with fast approximation
}
}
\examples{
\donttest{
GGML_GLU_OP_REGLU       # 0 - ReLU gating
GGML_GLU_OP_GEGLU       # 1 - GELU gating
GGML_GLU_OP_SWIGLU      # 2 - SiLU/Swish gating
GGML_GLU_OP_SWIGLU_OAI  # 3 - SwiGLU OpenAI
GGML_GLU_OP_GEGLU_ERF   # 4 - GELU with erf
GGML_GLU_OP_GEGLU_QUICK # 5 - Fast GELU
}
}
\keyword{datasets}
