% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_pad}
\alias{ggml_pad}
\title{Pad Tensor with Zeros (Graph)}
\usage{
ggml_pad(ctx, a, p0 = 0L, p1 = 0L, p2 = 0L, p3 = 0L)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor to pad}

\item{p0}{Padding for dimension 0 (default 0)}

\item{p1}{Padding for dimension 1 (default 0)}

\item{p2}{Padding for dimension 2 (default 0)}

\item{p3}{Padding for dimension 3 (default 0)}
}
\value{
Padded tensor with shape [ne0+p0, ne1+p1, ne2+p2, ne3+p3]
}
\description{
Pads tensor dimensions with zeros on the right side.
Useful for aligning tensor sizes in attention operations.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 5, 3)
ggml_set_f32(a, 1:15)
# Pad to 8x4
b <- ggml_pad(ctx, a, 3, 1)  # Add 3 zeros to dim0, 1 to dim1
graph <- ggml_build_forward_expand(ctx, b)
ggml_graph_compute(ctx, graph)
# Result shape: [8, 4]
ggml_free(ctx)
}
}
