% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateW.R
\name{generateW}
\alias{generateW}
\title{Generate spatial weight matrices for simulation}
\usage{
generateW(
  method = c("rectangle", "line", "circle", "full", "independent"),
  dim,
  maxOrder = NULL,
  width = NULL,
  ...
)
}
\arguments{
\item{method}{(character scalar) Defines type of neighborhood structure. Options are "rectangle", "line", "circle", "full", and "independent". Default is "rectangle".}

\item{dim}{(integer scalar) Number of locations, i.e. dimension of the time series.}

\item{maxOrder}{(integer scalar) Maximum spatial order up to which the spatial weight matrices are generated. Ignored if `method`` is "full" or "independent".}

\item{width}{(integer scalar) Width of the rectangular grid. Must be a divisor of \code{dim}. Ignored if \code{method} is not "rectangle".}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
A list of (row normalized) spatial weight matrices.
}
\description{
This function generates row-normalized spatial weight matrices for different types of neighborhood structures.
}
\details{
The function generates spatial weight matrices for different types of neighborhood structures. The options are:
\itemize{
\item "rectangle" - A regular rectangular grid (2 dimensional) with \code{width} columns and \code{dim / width} rows. The spatial order is defined by the Euclidean distances between locations.
\item "line" - Locations are placed on a line (1 dimensional). The spatial order is defined by the Euclidean distances between locations.
\item "circle" - Locations are placed on a circle. The spatial order is defined by the Euclidean distances between locations. In contrast to the "line" neighborhood, there are no boundary locations.
\item "full" - Generates a list with \code{dim^2} matrices. Allows simulation/fitting of a full time series model without any restrictions in dependencies between the locations. Not recommended if \code{dim} is large.
\item "independent" - Generates a list with \code{dim} matrices. Each matrix is a spatial weight matrix with a single 1 in the diagonal. Allows simultaneously simulation/fitting of \code{dim} univariate time series models without spatial dependencies.
}
}
\examples{
generateW(method = "rectangle", dim = 100, maxOrder = 2, width = 5)
generateW(method = "full", dim = 4)
}
\references{
For more advanced spatial weight matrices, consider using the \code{spdep} package.
\itemize{
\item Bivand R, Pebesma E, Gómez-Rubio V (2013). \emph{Applied spatial data analysis with R}, Second edition. Springer, NY. \url{https://asdar-book.org/}.
\item Pebesma E, Bivand R (2023). \emph{Spatial Data Science With Applications in R}. Chapman & Hall. \url{https://r-spatial.org/book/}.
}
}
