% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_glmstarma.R
\name{summary.dglmstarma}
\alias{summary.dglmstarma}
\title{Summarize a dglmstarma Model}
\usage{
\method{summary}{dglmstarma}(object, phi = 1, alternative = c("two.sided", "less", "greater"), ...)
}
\arguments{
\item{object}{An object of class \code{dglmstarma}}

\item{phi}{Numeric value indicating the null hypothesis value for the dispersion parameter test. Default is 1.}

\item{alternative}{Character string specifying the alternative hypothesis for the dispersion parameter test. Must be one of "two.sided" (default), "less" or "greater".}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
An object of class \code{summary.dglmstarma} which contains the following elements
\itemize{
\item call: The function call to fit the model
\item coefficients_mean: The estimated coefficients of the mean model with approximate standard errors, z- and p-values. See details.
\item coefficients_dispersion: The estimated coefficients of the dispersion model with approximate standard errors, z- and p-values. See details.
\item distribution: The marginal distribution of the conditional observations.
\item link: The link-function used to connect the conditional mean with the linear process of the mean model.
\item dispersion_link: The link-function used to connect the dispersion with the linear process of the dispersion model.
\item dispersion_disp_parameter: The dispersion parameter of the dispersion family
\item df_mean: Number of estimated coefficients in the mean model
\item df_dispersion: Number of estimated coefficients in the dispersion model
\item log_likelihood: The quasi-log-likelihood of the estimated model. See details.
\item aic: Akaike Information Criterion of the estimated model, see \link{information_criteria} with \code{adjust = TRUE}.
\item bic: Bayesian Information Criterion of the estimated model, see \link{information_criteria} with \code{adjust = TRUE}.
\item qic: Quasi Information Criterion of the estimated model, see \link{QIC} with \code{adjust = TRUE}.
}
}
\description{
This functions summarizes the model fit of a dglmstarma model.
}
\details{
Standard errors, z-values and p-values are computed assuming asymptotic normality of the parameter estimation. The variance estimation is based on the sandwich estimator to adjust for quasi-maximum-likelihood estimation.
If the model requires non-negative parameters, the p-values are adjusted accordingly. Note that this adjustment is only valid for testing single parameters against the null hypothesis of being zero.
If multiple parameters are tested simultaneously, or a linear combination of them, a different adjustment is necessary.

If the dispersion model is constant, i.e. it is only an intercept model, a test is performed to test whether the estimated dispersion parameter is significantly different from the null hypothesis value \code{phi}.
The alternative hypothesis can be specified via the \code{alternative} argument. This can be useful to test for overdispersion or underdispersion in the data.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary
mean_model <- list(past_obs = rep(1, 7))
dispersion_model <- list(past_obs = 1)
fit <- dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"), 
                   dispersion_link = "log", wlist = W_hungary, 
                   mean_covariates = list(population = population_hungary))
summary(fit)
}
}
\seealso{
\link{dglmstarma}, \link{summary.glmstarma}
}
