% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_season_stats.R
\name{list_tournaments}
\alias{list_tournaments}
\title{List Available Tournaments}
\usage{
list_tournaments(year, tour = "pga")
}
\arguments{
\item{year}{Season year (e.g., 2025)}

\item{tour}{Tour name: "pga" (default), "liv", "lpga", "euro", or "champions".}
}
\value{
Tibble with event_id, tournament_name, start_date, end_date
}
\description{
Get a list of all available tournaments for a given year.
}
\examples{
\donttest{
# See all 2025 PGA tournaments
list_tournaments(2025)

# See LIV Golf schedule
list_tournaments(2026, tour = "liv")
}
}
