% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFSformat.R
\name{CFS_format}
\alias{CFS_format}
\title{Convert tree-ring data into CFS-TRenD format}
\usage{
CFS_format(data, usage, out.csv = NULL)
}
\arguments{
\item{data}{a list, first is input data in wide format; second is a flat sequence referring to the column indices of ring measurement variables}

\item{usage}{1: for submission data, 2: for cfstrend id structure to perform the analyse}

\item{out.csv}{output csv file (default is NULL, otherwise to specify the directory to output)}
}
\value{
A list of 3 elements:
1) A list containing seven tables compatible with CFS-TRenD data structure;
2) A data table containing all the meta-data and ring width measurement in wide format;
3) A data table for the percentage of completeness of each variable.
}
\description{
converts tree-ring data from various formats into a format compatible with hierarchical structure of the CFS-TRenD data collection (Girardin et al., 2021).
}
\examples{

# ring measurement
dt.samples <- data.table::fread(
system.file("extdata", "dt.samples.csv", package = "growthTrendR"))
# formatting the users' data conformed to CFS-TRenD data structure
dt.samples_trt <- CFS_format(data = list(dt.samples, 39:68), usage = 1, out.csv = NULL)
# save it to extdata for further use
# saveRDS(dt.samples_trt, file = "inst/extdata/dt.samples_trt.rds")

}
\references{
Girardin, M.P., Guo, X.J., Metsaranta, J., Gervais, D., Campbell, E., Arsenault, A., Isaac-Rentone, M., Harvey, J.E., Bhatti, J., Hogg, E.A. 2021. A national tree-ring repository for Canadian forests (CFS-TRenD): structure, synthesis and applications. Environmental Reviews, 29 (999), 1-17. https://doi.org/10.1139/er-2020-0099
}
