% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsNBCalendar.R
\name{compute_info_at_time}
\alias{compute_info_at_time}
\title{Compute statistical information at analysis time}
\usage{
compute_info_at_time(
  analysis_time,
  accrual_rate,
  accrual_duration,
  lambda1,
  lambda2,
  dispersion,
  ratio = 1,
  dropout_rate = 0,
  event_gap = 0,
  max_followup = Inf
)
}
\arguments{
\item{analysis_time}{The calendar time of the analysis.}

\item{accrual_rate}{The enrollment rate (subjects per time unit).}

\item{accrual_duration}{The duration of the enrollment period.}

\item{lambda1}{Event rate for group 1 (control).}

\item{lambda2}{Event rate for group 2 (treatment).}

\item{dispersion}{The negative binomial dispersion parameter.}

\item{ratio}{Allocation ratio (n2/n1). Default is 1.}

\item{dropout_rate}{Dropout rate (hazard rate). Default is 0.}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Default is 0.}

\item{max_followup}{Maximum follow-up time per subject. Exposure time is
truncated at this value. Default is \code{Inf} (no truncation).}
}
\value{
The statistical information (inverse of variance) at the analysis time.
}
\description{
Computes the statistical information for the log rate ratio at a given
analysis time, accounting for staggered enrollment and varying exposure times.
}
\examples{
compute_info_at_time(
  analysis_time = 12,
  accrual_rate = 10,
  accrual_duration = 10,
  lambda1 = 0.5,
  lambda2 = 0.3,
  dispersion = 0.1
)
}
