% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsNBCalendar.R
\name{gsNBCalendar}
\alias{gsNBCalendar}
\title{Group sequential design for negative binomial outcomes}
\usage{
gsNBCalendar(
  x,
  k = 3,
  test.type = 4,
  alpha = 0.025,
  beta = 0.1,
  astar = 0,
  delta = 0,
  sfu = gsDesign::sfHSD,
  sfupar = -4,
  sfl = gsDesign::sfHSD,
  sflpar = -2,
  tol = 1e-06,
  r = 18,
  usTime = NULL,
  lsTime = NULL,
  analysis_times = NULL
)
}
\arguments{
\item{x}{An object of class \code{sample_size_nbinom_result} from
\code{\link[=sample_size_nbinom]{sample_size_nbinom()}}.}

\item{k}{Number of analyses (interim + final). Default is 3.}

\item{test.type}{Test type as in \code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}}:
\describe{
\item{1}{One-sided}
\item{2}{Two-sided symmetric}
\item{3}{Two-sided, asymmetric, binding futility bound, beta-spending}
\item{4}{Two-sided, asymmetric, non-binding futility bound, beta-spending}
\item{5}{Two-sided, asymmetric, binding futility bound, lower spending}
\item{6}{Two-sided, asymmetric, non-binding futility bound, lower spending}
}
Default is 4.}

\item{alpha}{Type I error (one-sided). Default is 0.025.}

\item{beta}{Type II error (1 - power). Default is 0.1.}

\item{astar}{Allocated Type I error for lower bound for test.type = 5 or 6.
Default is 0.}

\item{delta}{Standardized effect size. Default is 0 (computed from design).}

\item{sfu}{Spending function for upper bound. Default is \code{gsDesign::sfHSD}.}

\item{sfupar}{Parameter for upper spending function. Default is -4.}

\item{sfl}{Spending function for lower bound. Default is \code{gsDesign::sfHSD}.}

\item{sflpar}{Parameter for lower spending function. Default is -2.}

\item{tol}{Tolerance for convergence. Default is 1e-06.}

\item{r}{Integer controlling grid size for numerical integration.
Default is 18.}

\item{usTime}{Spending time for upper bound (optional).}

\item{lsTime}{Spending time for lower bound (optional).}

\item{analysis_times}{Vector of calendar times for each analysis.
Must have length k. These times are stored in the \code{T}
element and displayed by \code{\link[gsDesign:gsBoundSummary]{gsDesign::gsBoundSummary()}}.}
}
\value{
An object of class \code{gsNB} which inherits from \code{gsDesign}
and \code{sample_size_nbinom_result}.
While the final sample size would be planned total enrollment, interim analysis
sample sizes are the expected number enrolled at the times specified in \code{analysis_times}.
Output value contains all elements from
\code{\link[gsDesign:gsDesign]{gsDesign::gsDesign()}} plus:
\describe{
\item{nb_design}{The original \code{sample_size_nbinom_result} object}
\item{n1}{A vector with sample size per analysis for group 1}
\item{n2}{A vector with sample size per analysis for group 2}
\item{n_total}{A vector with total sample size per analysis}
\item{events}{A vector with expected total events per analysis}
\item{events1}{A vector with expected events per analysis for group 1}
\item{events2}{A vector with expected events per analysis for group 2}
\item{exposure}{A vector with expected average calendar exposure per analysis}
\item{exposure_at_risk1}{A vector with expected at-risk exposure per analysis for group 1}
\item{exposure_at_risk2}{A vector with expected at-risk exposure per analysis for group 2}
\item{variance}{A vector with variance of log rate ratio per analysis}
\item{T}{Calendar time at each analysis (if \code{analysis_times} provided)}
}
Note that \code{n.I} in the returned object represents the statistical information
at each analysis.
}
\description{
Creates a group sequential design for negative binomial outcomes based on
sample size calculations from \code{\link[=sample_size_nbinom]{sample_size_nbinom()}}.
}
\examples{
# First create a sample size calculation
nb_ss <- sample_size_nbinom(
  lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1, power = 0.9,
  accrual_rate = 10, accrual_duration = 20, trial_duration = 24
)

# Then create a group sequential design with analysis times
gs_design <- gsNBCalendar(nb_ss,
  k = 3, test.type = 4,
  analysis_times = c(10, 18, 24)
)
}
\references{
Jennison, C. and Turnbull, B.W. (2000),
\emph{Group Sequential Methods with Applications to Clinical Trials}.
Boca Raton: Chapman and Hall.
}
