% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_sim_seasonal.R
\name{nb_sim_seasonal}
\alias{nb_sim_seasonal}
\title{Simulate recurrent events with seasonal rates}
\usage{
nb_sim_seasonal(
  enroll_rate,
  fail_rate,
  dropout_rate = NULL,
  max_followup = NULL,
  randomization_start_date = NULL,
  n = NULL,
  block = c(rep("Control", 2), rep("Experimental", 2))
)
}
\arguments{
\item{enroll_rate}{A data frame with columns \code{rate} and \code{duration}.}

\item{fail_rate}{A data frame with columns \code{treatment}, \code{season}, \code{rate}, and optionally \code{dispersion}.
Seasons should be "Spring", "Summer", "Fall", "Winter".}

\item{dropout_rate}{A data frame with columns \code{treatment}, \code{rate}, \code{duration}.}

\item{max_followup}{Numeric. Max follow-up duration (years).}

\item{randomization_start_date}{Date. Start of randomization.}

\item{n}{Integer. Total sample size.}

\item{block}{Character vector for block randomization.}
}
\value{
A data frame of class \code{nb_sim_seasonal} with columns:
\code{id}, \code{treatment}, \code{season}, \code{enroll_time}, \code{start}, \code{end}, \code{event}, \code{calendar_start}, \code{calendar_end}.
Rows represent intervals of risk or events. \code{event=1} indicates an event at \code{end}.
\code{event=0} indicates censoring or end of a seasonal interval at \code{end}.
}
\description{
Simulates recurrent events where event rates depend on the season.
}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(
  treatment = rep(c("Control", "Experimental"), each = 4),
  season = rep(c("Winter", "Spring", "Summer", "Fall"), times = 2),
  rate = c(0.6, 0.5, 0.4, 0.5, 0.4, 0.3, 0.2, 0.3)
)
sim <- nb_sim_seasonal(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  max_followup = 1,
  randomization_start_date = as.Date("2020-01-01"),
  n = 20
)
head(sim)
}
