% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-space.R
\name{ParamSpace}
\alias{ParamSpace}
\title{ParamSpace}
\description{
ParamSpace

ParamSpace
}
\details{
Internal R6 class to manage tuned parameters, candidate generation, and
dependencies for grid and random search.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{Named list of tuned parameter specifications.}

\item{\code{order}}{Topologically sorted parameter IDs for dependency resolution.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParamSpace-new}{\code{ParamSpace$new()}}
\item \href{#method-ParamSpace-add_param}{\code{ParamSpace$add_param()}}
\item \href{#method-ParamSpace-set_dependency}{\code{ParamSpace$set_dependency()}}
\item \href{#method-ParamSpace-validate}{\code{ParamSpace$validate()}}
\item \href{#method-ParamSpace-grid}{\code{ParamSpace$grid()}}
\item \href{#method-ParamSpace-sample_random}{\code{ParamSpace$sample_random()}}
\item \href{#method-ParamSpace-clone}{\code{ParamSpace$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-new}{}}}
\subsection{Method \code{new()}}{
Create a new parameter space.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-add_param"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-add_param}{}}}
\subsection{Method \code{add_param()}}{
Add a tuned parameter specification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$add_param(id, spec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Parameter ID (argument name).}

\item{\code{spec}}{Tuning specification (\verb{tune_*()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-set_dependency"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-set_dependency}{}}}
\subsection{Method \code{set_dependency()}}{
Set a dependency mapping for a tuned parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$set_dependency(id, depends_on, map)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Parameter ID to modify.}

\item{\code{depends_on}}{Names that must be available in the context.}

\item{\code{map}}{Mapping function returning a \verb{tune_*()} spec or fixed value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-validate"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the space and compute dependency order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$validate(base_context = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_context}}{Named list of fixed values available for dependencies.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-grid"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-grid}{}}}
\subsection{Method \code{grid()}}{
Generate a dependency-aware Cartesian product (grid).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$grid(base_context = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_context}}{Named list of fixed values available for dependencies.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-sample_random"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-sample_random}{}}}
\subsection{Method \code{sample_random()}}{
Sample configurations at random.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$sample_random(n, base_context = list(), seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of configurations to sample.}

\item{\code{base_context}}{Named list of fixed values available for dependencies.}

\item{\code{seed}}{Optional seed for reproducible sampling.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSpace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSpace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSpace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
