\name{corrUnif}
\alias{corrUnif}
\title{Uniform correlation matrix}
\usage{corrUnif(rho=0, tfu)}
\description{Constructs a uniform correlation matrix.}
\arguments{
 \item{rho}{Correlation parameter.}
 \item{tfu}{Follow-up time points, in standardized format from function
 \code{\link{tfuStandard}}.}
}
\value{
 Returns an \code{s} x \code{s} correlation matrix. Where \code{s} is the number
 of occasions (follow-up time points) at which the study outcome is observed.
}
\examples{

 # Uniform correlation model for outcomes at 3, 6, 12 and 24 months
 # Settings for tref argument of standardtfu do not change correlation matrix
 corrUnif(0.5, tfuStandard(c(3,6,12,24), tref=c(1,2)))

 # Based on correlation 0.5 between outcomes separated by 1 year
 corrUnif(0.5, tfuStandard(c(3,6,12,24), tref=c(3,4)))

}
