% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnes.R
\name{cnes_data}
\alias{cnes_data}
\title{Download CNES Health Facility Registry Data}
\usage{
cnes_data(
  year,
  type = "ST",
  month = NULL,
  vars = NULL,
  uf = NULL,
  parse = TRUE,
  col_types = NULL,
  cache = TRUE,
  cache_dir = NULL,
  lazy = FALSE,
  backend = c("arrow", "duckdb")
)
}
\arguments{
\item{year}{Integer. Year(s) of the data. Required.}

\item{type}{Character. File type to download. Default: \code{"ST"}
(establishments). See \code{\link{cnes_info}()} for all 13 types.}

\item{month}{Integer. Month(s) of the data (1-12). If NULL (default),
downloads all 12 months. Example: \code{1} (January), \code{1:6}
(first semester).}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all available variables. Use \code{\link{cnes_variables}()} to see
available variables.}

\item{uf}{Character. Two-letter state abbreviation(s) to download.
If NULL (default), downloads all 27 states.
Example: \code{"SP"}, \code{c("SP", "RJ")}.}

\item{parse}{Logical. If TRUE (default), converts columns to
appropriate types (integer, double, Date) based on the variable
metadata. Use \code{\link{cnes_variables}()} to see the target type for
each variable. Set to FALSE for backward-compatible all-character output.}

\item{col_types}{Named list. Override the default type for specific
columns. Names are column names, values are type strings:
\code{"character"}, \code{"integer"}, \code{"double"},
\code{"date_dmy"}, \code{"date_ymd"}, \code{"date_ym"}, \code{"date"}.
Example: \code{list(COMPETEN = "character")} to keep COMPETEN as character.}

\item{cache}{Logical. If TRUE (default), caches downloaded data for
faster future access.}

\item{cache_dir}{Character. Directory for caching. Default:
\code{tools::R_user_dir("healthbR", "cache")}.}

\item{lazy}{Logical. If TRUE, returns a lazy query object instead of a
tibble. Requires the \pkg{arrow} package. The lazy object supports
dplyr verbs (filter, select, mutate, etc.) which are pushed down
to the query engine before collecting into memory. Call
\code{dplyr::collect()} to materialize the result. Default: FALSE.}

\item{backend}{Character. Backend for lazy evaluation: \code{"arrow"}
(default) or \code{"duckdb"}. Only used when \code{lazy = TRUE}.
DuckDB backend requires the \pkg{duckdb} package.}
}
\value{
A tibble with health facility data. Includes columns
\code{year}, \code{month}, and \code{uf_source} to identify the source
when multiple years/months/states are combined.
}
\description{
Downloads and returns health facility registry data from DATASUS FTP.
Each row represents one health facility record (for the ST type).
Data is organized monthly -- one .dbc file per type, state (UF), and month.
}
\details{
Data is downloaded from DATASUS FTP as .dbc files (one per type/state/month).
The .dbc format is decompressed internally using vendored C code from the
blast library. No external dependencies are required.

CNES data is monthly, so downloading an entire year for all states requires
324 files (27 UFs x 12 months) per type. Use \code{uf} and \code{month}
to limit downloads.

The CNES has 13 file types. The default \code{"ST"} (establishments) is
the most commonly used. Use \code{\link{cnes_info}()} to see all types.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# all establishments in Acre, January 2023
ac_jan <- cnes_data(year = 2023, month = 1, uf = "AC")

# only key variables
cnes_data(year = 2023, month = 1, uf = "AC",
          vars = c("CNES", "CODUFMUN", "TP_UNID", "VINC_SUS"))

# hospital beds
leitos <- cnes_data(year = 2023, month = 1, uf = "AC", type = "LT")

# health professionals
prof <- cnes_data(year = 2023, month = 1, uf = "AC", type = "PF")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cnes_info}()} for file type descriptions,
\code{\link{censo_populacao}()} for population denominators.

Other cnes: 
\code{\link{cnes_cache_status}()},
\code{\link{cnes_clear_cache}()},
\code{\link{cnes_dictionary}()},
\code{\link{cnes_info}()},
\code{\link{cnes_variables}()},
\code{\link{cnes_years}()}
}
\concept{cnes}
