% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_plot.R
\name{classPlot}
\alias{classPlot}
\title{Plot bars for item counts grouped and colored by class}
\usage{
classPlot(
  df,
  title = NULL,
  xLab = "Value",
  yLab = "Item",
  legendTitle = "Class",
  palette = "Spectral",
  labelSize = 2.5,
  labelColor = "black",
  legendTitleSize = 10,
  legendTextSize = 10,
  axisTextSize = 12,
  axisTitleSize = 12,
  decreasing = TRUE,
  valueCutoff = 0,
  ...
)
}
\arguments{
\item{df}{A data frame with at least three columns. Its first column
(categorical) colors the plot bars. The second column (categorical)
labels the plots bars. The third column (numeric) sets the bar lengths.}

\item{title}{Plot title.}

\item{xLab}{x axis label.}

\item{yLab}{y axis label.}

\item{legendTitle}{Legend title.}

\item{palette}{Color palette.}

\item{labelSize}{Label size.}

\item{labelColor}{Label color.}

\item{legendTitleSize}{Legend title size.}

\item{legendTextSize}{Legend text size.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{decreasing}{Whether to display the bars in decreasing order of length.}

\item{valueCutoff}{Cutoff used for filtering the input data frame based on
the third (value) column. Only values above this cutoff will be displayed on
the plot.}

\item{...}{Additional arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function plots bars for item counts grouped and colored by class.
}
\examples{
 df <- data.frame(Class = sample(paste0('C', seq(13)), 25, replace=TRUE),
 Item = paste0('I', seq(25)),
 Value = runif(25, 0.5, 1))
 classPlot(df)

 df <- data.frame(Class = sample(paste0('C', seq(13)), 25, replace=TRUE),
 Item = sample(paste0('I', seq(21)), 25, replace=TRUE),
 Value = runif(25, 0.5, 1))
 classPlot(df)

}
