## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 5.5,
  fig.height = 4.5,
  fig.align = "center",
  dpi = 150
)

## ----load---------------------------------------------------------------------
# load the package
library(iv.sensemakr)

# load the dataset
data("card")

## ----ols----------------------------------------------------------------------
# OLS regression of log wages on education and covariates
card.ols <- lm(lwage ~ educ + exper + expersq + black + south + smsa + reg661 +
                  reg662 + reg663 + reg664 + reg665 + reg666 +
                  reg667 + reg668 + smsa66,
                data = card)
coef(card.ols)["educ"]
confint(card.ols)["educ", ]

## ----fit----------------------------------------------------------------------
# prepare data
y <- card$lwage  # outcome: log wage
d <- card$educ   # treatment: years of education
z <- card$nearc4 # instrument: proximity to college
x <- model.matrix(~ exper + expersq + black + south + smsa + reg661 +
                     reg662 + reg663 + reg664 + reg665 + reg666 +
                     reg667 + reg668 + smsa66,
                   data = card)

# fit the IV model
card.fit <- iv_fit(y, d, z, x)
card.fit

## ----sensemakr-full-----------------------------------------------------------
# with all parameters shown explicitly
card.sens <- sensemakr(model = card.fit,
                       benchmark_covariates = c("black", "smsa"),
                       kz = 1,               # benchmark multiplier for Z
                       ky = 1,               # benchmark multiplier for Y
                       q = 1,                # reduce estimate to zero
                       alpha = 0.05)         # significance level

## ----sensemakr-simple---------------------------------------------------------
card.sens <- sensemakr(card.fit, benchmark_covariates = c("black", "smsa"))

## -----------------------------------------------------------------------------
card.sens

## ----plot-ci, fig.width = 10, fig.height = 5----------------------------------
plot(card.sens, lim = 0.09)

