% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Kendall}
\alias{Kendall}
\title{Kendall's tau kernel}
\usage{
Kendall(X, NA.as.0 = TRUE, samples.in.rows = FALSE, comp = "mean")
}
\arguments{
\item{X}{When evaluating a single ordinal feature, X should be a numeric matrix
or data.frame. If data is multivariate, X should be a list, and each ordinal/ranking
feature should be placed in a different element of the list (see Examples).}

\item{NA.as.0}{Should NAs be converted to 0s? (Defaults: TRUE).}

\item{samples.in.rows}{If TRUE, the samples are considered to be in the rows.
Otherwise, it is assumed that they are in the columns. (Defaults: FALSE).}

\item{comp}{If X is a list, this argument indicates how the ordinal/ranking variables
are combined. Options are: "mean" and "sum". (Defaults: "mean").}
}
\value{
Kernel matrix (dimension: \emph{NxN}).
}
\description{
`Kendall()` computes the Kendall's tau, which happens to be a kernel function
for ordinal variables, ranks or permutations.
}
\examples{
# 3 people are given a list of 10 colors. They rank them from most (1) to least
# (10) favorite
color_list <-  c("black","blue","green","grey","lightblue","orange","purple",
"red","white","yellow")
survey1 <- 1:10
survey2 <- 10:1
survey3 <- sample(10)
color <- cbind(survey1,survey2,survey3) # Samples in columns
rownames(color) <- color_list
Kendall(color)

# The same 3 people are asked the number of times they ate 5 different kinds of
# food during the last month:
food <- matrix(c(10, 1,18, 25,30, 7, 5,20, 5, 12, 7,20, 20, 3,22),ncol=5,nrow=3)
rownames(food) <- colnames(color)
colnames(food) <- c("spinach", "chicken", "beef" , "salad","lentils")
# (we can observe that, for person 2, vegetables << meat, while for person 3
# is the other way around)
Kendall(food,samples.in.rows=TRUE)

# We can combine this results:
dataset <- list(color=color,food=t(food)) #All samples in columns
Kendall(dataset)
}
\references{
Jiao, Y. and Vert, J.P.
The Kendall and Mallows kernels for permutations. International Conference on Machine Learning.
PMLR, 2015. \href{https://proceedings.mlr.press/v37/jiao15.html}{Link}
}
